/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class FileOffsetRange
implements Serializable {
    private static final long serialVersionUID = 7069346824354308L;
    private long start;
    private long size;

    public FileOffsetRange(long start2, long size) {
        this.start = (Long)Preconditions.checkNotNull((Object)start2);
        this.size = (Long)Preconditions.checkNotNull((Object)size);
    }

    public FileOffsetRange normalize(long fileLength) {
        long startTmp;
        long count = this.size > fileLength ? fileLength : this.size;
        long l = startTmp = this.start < 0L ? fileLength + this.start : this.start;
        if (startTmp <= 0L) {
            startTmp = 0L;
        } else if (startTmp >= fileLength) {
            startTmp = fileLength - count;
        }
        long sizeTmp = Math.abs(this.size > fileLength || this.size == FileOffsetRange.getSizeDefaultValue() ? fileLength : this.size);
        long end = sizeTmp + startTmp;
        if (end > fileLength) {
            sizeTmp = fileLength - startTmp;
        }
        this.start = startTmp;
        this.size = sizeTmp;
        return this;
    }

    public long getStart() {
        return this.start;
    }

    public long getSize() {
        return this.size;
    }

    public static long getStartDefaultValue() {
        return 0L;
    }

    public static long getSizeDefaultValue() {
        return -1L;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == FileOffsetRange.class) {
            FileOffsetRange that = (FileOffsetRange)obj;
            return this.getStart() == that.getStart() && this.getSize() == that.getSize();
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.start, this.size);
    }

    public String toString() {
        return "start=" + this.start + ", size=" + this.size;
    }
}

