/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public final class NioBufferedFileInputStream
extends InputStream {
    private final ByteBuffer byteBuffer;
    private final FileChannel fileChannel;

    public NioBufferedFileInputStream(FileChannel fileChannel, int bufferSizeInBytes) throws IOException {
        this.byteBuffer = ByteBuffer.allocateDirect(bufferSizeInBytes);
        this.fileChannel = fileChannel;
        this.byteBuffer.flip();
    }

    private boolean refill() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            this.byteBuffer.clear();
            int nRead = 0;
            while (nRead == 0) {
                nRead = this.fileChannel.read(this.byteBuffer);
            }
            if (nRead < 0) {
                return false;
            }
            this.byteBuffer.flip();
        }
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.refill()) {
            return -1;
        }
        return this.byteBuffer.get() & 0xFF;
    }

    @Override
    public synchronized int read(byte[] b, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len < 0 || offset + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.refill()) {
            return -1;
        }
        len = Math.min(len, this.byteBuffer.remaining());
        this.byteBuffer.get(b, offset, len);
        return len;
    }

    public synchronized int read(ByteBuffer b) throws IOException {
        if (!this.refill()) {
            return -1;
        }
        int len = b.remaining();
        if ((len = Math.min(len, this.byteBuffer.remaining())) > 0) {
            ByteBuffer src = this.byteBuffer.duplicate();
            src.limit(src.position() + len);
            b.put(src);
            this.byteBuffer.position(src.position());
        }
        return len;
    }

    public synchronized void continuousRead(ByteBuffer b) throws IOException {
        while (b.remaining() > 0) {
            int result = this.read(b);
            if (result != -1) continue;
            return;
        }
    }

    @Override
    public synchronized int available() throws IOException {
        long avail = this.fileChannel.size() - this.fileChannel.position() + (long)this.byteBuffer.remaining();
        return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
    }

    public long position() throws IOException {
        return this.fileChannel.position() - (long)this.byteBuffer.remaining();
    }

    public long size() throws IOException {
        return this.fileChannel.size();
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if ((long)this.byteBuffer.remaining() >= n) {
            this.byteBuffer.position(this.byteBuffer.position() + (int)n);
            return n;
        }
        long skippedFromBuffer = this.byteBuffer.remaining();
        long toSkipFromFileChannel = n - skippedFromBuffer;
        this.byteBuffer.position(0);
        this.byteBuffer.flip();
        return skippedFromBuffer + this.skipFromFileChannel(toSkipFromFileChannel);
    }

    private long skipFromFileChannel(long n) throws IOException {
        long currentFilePosition = this.fileChannel.position();
        long size = this.fileChannel.size();
        if (n > size - currentFilePosition) {
            this.fileChannel.position(size);
            return size - currentFilePosition;
        }
        this.fileChannel.position(currentFilePosition + n);
        return n;
    }

    public void clearBuffer() {
        this.byteBuffer.clear();
        this.byteBuffer.flip();
    }

    @Override
    public synchronized void close() throws IOException {
        Cleaner cleaner;
        if (this.byteBuffer != null && this.byteBuffer instanceof MappedByteBuffer && (cleaner = ((DirectBuffer)((Object)this.byteBuffer)).cleaner()) != null) {
            cleaner.clean();
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }
}

