/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentWritable;
import org.apache.flink.util.FileUtils;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class NioBufferedFileOutputStream
implements MemorySegmentWritable {
    private final FileChannel fileChannel;
    private final ByteBuffer writeBuffer;
    private volatile boolean closed;

    public NioBufferedFileOutputStream(FileChannel fileChannel, int bufferSize) {
        this.fileChannel = fileChannel;
        this.writeBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    public void write(MemorySegment segment, int off, int len) throws IOException {
        this.write(segment.wrap(off, len));
    }

    public void write(ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            int toCopy = Math.min(buffer.remaining(), this.writeBuffer.remaining());
            if (toCopy > 0) {
                ByteBuffer src = buffer.duplicate();
                src.limit(src.position() + toCopy);
                this.writeBuffer.put(src);
                buffer.position(src.position());
            }
            if (this.writeBuffer.remaining() != 0) continue;
            this.flush();
        }
    }

    public void flush() throws IOException {
        if (!this.closed) {
            if (this.writeBuffer.position() > 0) {
                this.writeBuffer.flip();
                FileUtils.writeCompletely((WritableByteChannel)this.fileChannel, (ByteBuffer)this.writeBuffer);
                this.writeBuffer.clear();
            }
        } else {
            throw new IOException("closed");
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            Cleaner cleaner;
            this.flush();
            this.closed = true;
            if (this.writeBuffer != null && this.writeBuffer instanceof MappedByteBuffer && (cleaner = ((DirectBuffer)((Object)this.writeBuffer)).cleaner()) != null) {
                cleaner.clean();
            }
        }
    }
}

