/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class ShellCommandExecutor {
    private final String[] command;
    private final StringBuilder output = new StringBuilder();
    private int exitCode;

    public ShellCommandExecutor(String[] execString) {
        this.command = execString;
    }

    public void execute() throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(this.command);
        Process process = builder.start();
        this.exitCode = process.waitFor();
        try (BufferedReader inReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));){
            int readCount;
            char[] buf = new char[512];
            while ((readCount = inReader.read(buf, 0, buf.length)) > 0) {
                this.output.append(buf, 0, readCount);
            }
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String getOutput() {
        return this.output.toString();
    }
}

