/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.operators.ResourceConstraints;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.Resource;

public class ResourceProfile
implements Serializable,
Comparable<ResourceProfile> {
    private static final long serialVersionUID = 1L;
    public static final ResourceProfile UNKNOWN = new ResourceProfile(-1.0, -1);
    public static final ResourceProfile EMTPY = new ResourceProfile(0.0, 0);
    private double cpuCores;
    private int heapMemoryInMB;
    private int directMemoryInMB;
    private int nativeMemoryInMB;
    private int networkMemoryInMB;
    private Map<String, Resource> extendedResources = new HashMap<String, Resource>(1);
    private volatile int hashResult;
    private final ResourceConstraints resourceConstraints;

    public ResourceProfile(double cpuCores, int heapMemoryInMB, int directMemoryInMB, int nativeMemoryInMB, int networkMemoryInMB, Map<String, Resource> extendedResources, ResourceConstraints resourceConstraints) {
        this.cpuCores = cpuCores;
        this.heapMemoryInMB = heapMemoryInMB;
        this.directMemoryInMB = directMemoryInMB;
        this.nativeMemoryInMB = nativeMemoryInMB;
        this.networkMemoryInMB = networkMemoryInMB;
        if (extendedResources != null) {
            this.extendedResources.putAll(extendedResources);
        }
        this.resourceConstraints = resourceConstraints;
        this.updateHashCode();
    }

    public ResourceProfile(double cpuCores, int heapMemoryInMB, int directMemoryInMB, int nativeMemoryInMB, int networkMemoryInMB, Map<String, Resource> extendedResources) {
        this(cpuCores, heapMemoryInMB, directMemoryInMB, nativeMemoryInMB, networkMemoryInMB, extendedResources, null);
    }

    public ResourceProfile(double cpuCores, int heapMemoryInMB) {
        this(cpuCores, heapMemoryInMB, 0, 0, 0, Collections.emptyMap());
    }

    public ResourceProfile(ResourceProfile other) {
        this(other.cpuCores, other.heapMemoryInMB, other.directMemoryInMB, other.nativeMemoryInMB, other.networkMemoryInMB, other.extendedResources, other.resourceConstraints);
    }

    public ResourceConstraints getResourceConstraints() {
        return this.resourceConstraints;
    }

    public double getCpuCores() {
        return this.cpuCores;
    }

    public int getHeapMemoryInMB() {
        return this.heapMemoryInMB;
    }

    public int getDirectMemoryInMB() {
        return this.directMemoryInMB;
    }

    public int getNativeMemoryInMB() {
        return this.nativeMemoryInMB;
    }

    public int getNetworkMemoryInMB() {
        return this.networkMemoryInMB;
    }

    public int getMemoryInMB() {
        return this.heapMemoryInMB + this.directMemoryInMB + this.nativeMemoryInMB + this.networkMemoryInMB;
    }

    public int getOperatorsMemoryInMB() {
        return this.heapMemoryInMB + this.directMemoryInMB + this.nativeMemoryInMB;
    }

    public Map<String, Resource> getExtendedResources() {
        return Collections.unmodifiableMap(this.extendedResources);
    }

    public int getManagedMemoryInMB() {
        Resource managedMemory = this.extendedResources.get("MANAGED_MEMORY_MB");
        if (managedMemory != null) {
            return (int)managedMemory.getValue();
        }
        return 0;
    }

    public int getFloatingManagedMemoryInMB() {
        Resource floatingMemory = this.extendedResources.get("FLOATING_MANAGED_MEMORY_MB");
        if (floatingMemory != null) {
            return (int)floatingMemory.getValue();
        }
        return 0;
    }

    public boolean isMatching(ResourceProfile required) {
        if (this.resourceConstraints != null ? !this.resourceConstraints.equals((Object)required.getResourceConstraints()) : required.getResourceConstraints() != null) {
            return false;
        }
        if (this.cpuCores >= required.getCpuCores() && this.heapMemoryInMB >= required.getHeapMemoryInMB() && this.directMemoryInMB >= required.getDirectMemoryInMB() && this.nativeMemoryInMB >= required.getNativeMemoryInMB() && this.networkMemoryInMB >= required.getNetworkMemoryInMB()) {
            for (Map.Entry<String, Resource> resource : required.extendedResources.entrySet()) {
                if (resource.getKey().equals("FLOATING_MANAGED_MEMORY_MB") || this.extendedResources.containsKey(resource.getKey()) && this.extendedResources.get(resource.getKey()).getResourceAggregateType().equals((Object)resource.getValue().getResourceAggregateType()) && !(this.extendedResources.get(resource.getKey()).getValue() < resource.getValue().getValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull ResourceProfile other) {
        int cmp = Integer.compare(this.getMemoryInMB(), other.getMemoryInMB());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Double.compare(this.cpuCores, other.cpuCores);
        if (cmp != 0) {
            return cmp;
        }
        if (!this.extendedResources.isEmpty() && !other.extendedResources.isEmpty()) {
            boolean hasUniqueResource = this.extendedResources.size() != other.extendedResources.size();
            for (Map.Entry<String, Resource> resourceEntry : this.extendedResources.entrySet()) {
                Resource otherResource = other.extendedResources.get(resourceEntry.getKey());
                if (otherResource == null) {
                    hasUniqueResource = true;
                    continue;
                }
                Resource thisResource = resourceEntry.getValue();
                if (!otherResource.getResourceAggregateType().equals((Object)thisResource.getResourceAggregateType())) {
                    return 1;
                }
                cmp = Double.compare(thisResource.getValue(), otherResource.getValue());
                if (cmp == 0) continue;
                return cmp;
            }
            if (hasUniqueResource) {
                return this.hashCode() > other.hashCode() ? 1 : -1;
            }
        } else {
            cmp = this.extendedResources.size() - other.extendedResources.size();
        }
        if (cmp == 0) {
            if (this.resourceConstraints == null && other.getResourceConstraints() != null) {
                return 1;
            }
            if (this.resourceConstraints != null && other.getResourceConstraints() == null) {
                return -1;
            }
            if (this.resourceConstraints != null && other.resourceConstraints != null) {
                Iterator thisIterator = this.resourceConstraints.getConstraints().entrySet().iterator();
                Iterator otherIterator = other.resourceConstraints.getConstraints().entrySet().iterator();
                while (thisIterator.hasNext() && otherIterator.hasNext()) {
                    Map.Entry thisConstraint = thisIterator.next();
                    Map.Entry otherConstraint = otherIterator.next();
                    cmp = ((String)thisConstraint.getKey()).compareTo((String)otherConstraint.getKey());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = ((String)thisConstraint.getValue()).compareTo((String)otherConstraint.getValue());
                    if (cmp == 0) continue;
                    return cmp;
                }
                if (thisIterator.hasNext()) {
                    return -1;
                }
                if (otherIterator.hasNext()) {
                    return 1;
                }
            }
        }
        return cmp;
    }

    public ResourceProfile minus(ResourceProfile another) {
        for (String extendedResourceName : another.extendedResources.keySet()) {
            if (this.extendedResources.containsKey(extendedResourceName)) continue;
            throw new IllegalArgumentException("Non-exist extended resource: " + extendedResourceName);
        }
        HashMap<String, Resource> newExtendedResource = new HashMap<String, Resource>(this.extendedResources.size());
        for (Map.Entry<String, Resource> entry : this.extendedResources.entrySet()) {
            Resource anotherResource = another.extendedResources.get(entry.getKey());
            if (anotherResource == null) {
                newExtendedResource.put(entry.getKey(), entry.getValue());
                continue;
            }
            newExtendedResource.put(entry.getKey(), entry.getValue().minus(anotherResource));
        }
        return new ResourceProfile(this.cpuCores - another.cpuCores, this.heapMemoryInMB - another.heapMemoryInMB, this.directMemoryInMB - another.directMemoryInMB, this.nativeMemoryInMB - another.nativeMemoryInMB, this.networkMemoryInMB - another.networkMemoryInMB, newExtendedResource, this.resourceConstraints);
    }

    public ResourceProfile merge(ResourceProfile another) {
        ResourceProfile resourceProfile = new ResourceProfile(this);
        resourceProfile.addTo(another);
        return resourceProfile;
    }

    public void addTo(ResourceProfile another) {
        this.cpuCores += another.getCpuCores();
        this.heapMemoryInMB += another.getHeapMemoryInMB();
        this.directMemoryInMB += another.getDirectMemoryInMB();
        this.nativeMemoryInMB += another.getNativeMemoryInMB();
        this.networkMemoryInMB += another.getNetworkMemoryInMB();
        if (!this.extendedResources.isEmpty() || !another.extendedResources.isEmpty()) {
            for (Map.Entry<String, Resource> extendResource : another.extendedResources.entrySet()) {
                Resource rfValue = this.extendedResources.get(extendResource.getKey());
                if (rfValue != null) {
                    this.extendedResources.put(extendResource.getKey(), extendResource.getValue().merge(rfValue));
                    continue;
                }
                this.extendedResources.put(extendResource.getKey(), extendResource.getValue());
            }
        }
        this.updateHashCode();
    }

    public ResourceProfile multiply(int multiplier) {
        HashMap<String, Resource> newExtendedResource = new HashMap<String, Resource>(this.extendedResources.size());
        for (Map.Entry<String, Resource> entry : this.extendedResources.entrySet()) {
            newExtendedResource.put(entry.getKey(), entry.getValue().multiply(multiplier));
        }
        return new ResourceProfile(this.getCpuCores() * (double)multiplier, this.getHeapMemoryInMB() * multiplier, this.getDirectMemoryInMB() * multiplier, this.getNativeMemoryInMB() * multiplier, this.getNetworkMemoryInMB() * multiplier, newExtendedResource, this.resourceConstraints);
    }

    public ResourceProfile multiply(double multiplier) {
        HashMap<String, Resource> newExtendedResource = new HashMap<String, Resource>(this.extendedResources.size());
        for (Map.Entry<String, Resource> entry : this.extendedResources.entrySet()) {
            newExtendedResource.put(entry.getKey(), entry.getValue().multiply(multiplier));
        }
        return new ResourceProfile(this.getCpuCores() * multiplier, (int)((double)this.getHeapMemoryInMB() * multiplier), (int)((double)this.getDirectMemoryInMB() * multiplier), (int)((double)this.getNativeMemoryInMB() * multiplier), (int)((double)this.getNetworkMemoryInMB() * multiplier), newExtendedResource, this.resourceConstraints);
    }

    public int hashCode() {
        return this.hashResult;
    }

    private void updateHashCode() {
        long cpuBits = Double.doubleToLongBits(this.cpuCores);
        int result = (int)(cpuBits ^ cpuBits >>> 32);
        result = 31 * result + this.heapMemoryInMB;
        result = 31 * result + this.directMemoryInMB;
        result = 31 * result + this.nativeMemoryInMB;
        result = 31 * result + this.networkMemoryInMB;
        result = 31 * result + this.extendedResources.hashCode();
        if (this.resourceConstraints != null) {
            result = 31 * result + this.resourceConstraints.hashCode();
        }
        this.hashResult = result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == ResourceProfile.class) {
            ResourceProfile that = (ResourceProfile)obj;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            return this.cpuCores == that.cpuCores && this.heapMemoryInMB == that.heapMemoryInMB && this.directMemoryInMB == that.directMemoryInMB && this.nativeMemoryInMB == that.nativeMemoryInMB && this.networkMemoryInMB == that.networkMemoryInMB && Objects.equals(this.extendedResources, that.extendedResources) && (this.resourceConstraints != null && this.resourceConstraints.equals((Object)that.resourceConstraints) || this.resourceConstraints == null && that.resourceConstraints == null);
        }
        return false;
    }

    public String toString() {
        String strExtendedResource = "";
        if (!this.extendedResources.isEmpty()) {
            StringBuilder resources = new StringBuilder(this.extendedResources.size() * 10);
            for (Map.Entry<String, Resource> resource : this.extendedResources.entrySet()) {
                resources.append(", ").append(resource.getKey()).append('=').append(resource.getValue().getValue());
            }
            strExtendedResource = resources.toString();
        }
        String constraintsStr = null;
        if (this.resourceConstraints != null) {
            constraintsStr = this.resourceConstraints.toString();
        }
        return "ResourceProfile{cpuCores=" + this.cpuCores + ", heapMemoryInMB=" + this.heapMemoryInMB + ", directMemoryInMB=" + this.directMemoryInMB + ", nativeMemoryInMB=" + this.nativeMemoryInMB + ", networkMemoryInMB=" + this.networkMemoryInMB + strExtendedResource + ", ResourceConstraints=" + constraintsStr + '}';
    }

    public static ResourceProfile fromResourceSpec(ResourceSpec resourceSpec, int networkMemory) {
        HashMap<String, Resource> copiedExtendedResources = new HashMap<String, Resource>(resourceSpec.getExtendedResources());
        return new ResourceProfile(resourceSpec.getCpuCores(), resourceSpec.getHeapMemory(), resourceSpec.getDirectMemory(), resourceSpec.getNativeMemory(), networkMemory, copiedExtendedResources);
    }

    public static ResourceProfile fromResourceSpec(ResourceSpec resourceSpec, ResourceConstraints resourceConstraints, int networkMemory) {
        HashMap<String, Resource> copiedExtendedResources = new HashMap<String, Resource>(resourceSpec.getExtendedResources());
        return new ResourceProfile(resourceSpec.getCpuCores(), resourceSpec.getHeapMemory(), resourceSpec.getDirectMemory(), resourceSpec.getNativeMemory(), networkMemory, copiedExtendedResources, resourceConstraints);
    }
}

