/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.placementconstraint.SlotTag;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class SlotProfile {
    private static final SlotProfile NO_REQUIREMENTS = SlotProfile.noLocality(ResourceProfile.UNKNOWN);
    @Nonnull
    private final ResourceProfile resourceProfile;
    @Nonnull
    private final Collection<TaskManagerLocation> preferredLocations;
    @Nonnull
    private final Collection<AllocationID> priorAllocations;
    @Nonnull
    private final List<SlotTag> tags;

    public SlotProfile(@Nonnull ResourceProfile resourceProfile, @Nonnull Collection<TaskManagerLocation> preferredLocations, @Nonnull Collection<AllocationID> priorAllocations) {
        this(resourceProfile, preferredLocations, priorAllocations, new ArrayList<SlotTag>());
    }

    public SlotProfile(@Nonnull ResourceProfile resourceProfile, @Nonnull Collection<TaskManagerLocation> preferredLocations, @Nonnull Collection<AllocationID> priorAllocations, @Nonnull List<SlotTag> tags) {
        this.resourceProfile = resourceProfile;
        this.preferredLocations = preferredLocations;
        this.priorAllocations = priorAllocations;
        this.tags = tags;
    }

    @Nonnull
    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    @Nonnull
    public Collection<TaskManagerLocation> getPreferredLocations() {
        return this.preferredLocations;
    }

    @Nonnull
    public Collection<AllocationID> getPriorAllocations() {
        return this.priorAllocations;
    }

    @Nonnull
    public List<SlotTag> getTags() {
        return this.tags;
    }

    public static SlotProfile noRequirements() {
        return NO_REQUIREMENTS;
    }

    public static SlotProfile noLocality(ResourceProfile resourceProfile) {
        return new SlotProfile(resourceProfile, Collections.emptyList(), Collections.emptyList());
    }

    public static SlotProfile preferredLocality(ResourceProfile resourceProfile, Collection<TaskManagerLocation> preferredLocations) {
        return new SlotProfile(resourceProfile, preferredLocations, Collections.emptyList());
    }

    public static SlotProfile priorAllocation(ResourceProfile resourceProfile, Collection<AllocationID> priorAllocations) {
        return new SlotProfile(resourceProfile, Collections.emptyList(), priorAllocations);
    }
}

