/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.types;

import java.util.Objects;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.standalone.TaskManagerResourceCalculator;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.util.Preconditions;

public class TaskManagerResource {
    private final int taskManagerNettyMemorySizeMB;
    private final int taskManagerNativeMemorySizeMB;
    private final int taskManagerHeapMemorySizeMB;
    private final float managedMemoryFraction;
    private final boolean offHeap;
    private final boolean managedMemoryPreAllocate;
    private final double persistentYoungHeapRatio;
    private final double dynamicYoungHeapRatio;
    private ResourceProfile taskResourceProfile;
    private final int slotNum;
    private final int defaultNetworkMemMB;
    private final int defaultHeapMemMB;
    private int taskManagerTotalMemoryMB;

    private TaskManagerResource(int taskManagerNettyMemorySizeMB, int taskManagerNativeMemorySizeMB, int taskManagerHeapMemorySizeMB, float managedMemoryFraction, boolean offHeap, boolean preAllocate, int defaultNetworkMemMB, int defaultHeapMemMB, double dynamicYoungHeapRatio, double persistentYoungHeapRatio, ResourceProfile taskResourceProfile, int slotNum, int taskManagerTotalMemoryMB) {
        this.taskManagerNettyMemorySizeMB = taskManagerNettyMemorySizeMB;
        this.taskManagerNativeMemorySizeMB = taskManagerNativeMemorySizeMB;
        this.taskManagerHeapMemorySizeMB = taskManagerHeapMemorySizeMB;
        this.managedMemoryFraction = managedMemoryFraction;
        this.offHeap = offHeap;
        this.managedMemoryPreAllocate = preAllocate;
        this.defaultNetworkMemMB = defaultNetworkMemMB;
        this.defaultHeapMemMB = defaultHeapMemMB;
        this.taskResourceProfile = taskResourceProfile;
        this.slotNum = slotNum;
        this.persistentYoungHeapRatio = persistentYoungHeapRatio;
        this.dynamicYoungHeapRatio = dynamicYoungHeapRatio;
        this.taskManagerTotalMemoryMB = taskManagerTotalMemoryMB;
    }

    public int getTaskManagerNettyMemorySizeMB() {
        return this.taskManagerNettyMemorySizeMB;
    }

    public int getTotalContainerMemory() {
        if (this.taskManagerTotalMemoryMB > 0) {
            return this.taskManagerTotalMemoryMB;
        }
        return this.getTotalHeapMemory() + this.getTotalDirectMemory() + this.getTotalNativeMemory();
    }

    public int getManagedMemorySize() {
        return this.taskResourceProfile.getManagedMemoryInMB() * this.slotNum;
    }

    public int getFloatingManagedMemorySize() {
        return this.taskResourceProfile.getFloatingManagedMemoryInMB() * this.slotNum;
    }

    public int getNetworkMemorySize() {
        int networkMemoryInMB = this.taskResourceProfile.getNetworkMemoryInMB() * this.slotNum;
        return networkMemoryInMB > 0 ? networkMemoryInMB : this.defaultNetworkMemMB;
    }

    public int getTotalNativeMemory() {
        return this.taskResourceProfile.getNativeMemoryInMB() * this.slotNum + this.taskManagerNativeMemorySizeMB;
    }

    public int getTotalHeapMemory() {
        if (this.taskManagerTotalMemoryMB > 0) {
            int heap = this.taskManagerTotalMemoryMB - this.getTotalNativeMemory() - this.getTotalDirectMemory();
            Preconditions.checkArgument((heap > 0 ? 1 : 0) != 0, (Object)String.format("Total task manager memory(%s) should be more than the sum of native(%s) and direct(%s)", this.taskManagerTotalMemoryMB, this.getTotalNativeMemory(), this.getTotalDirectMemory()));
            return heap;
        }
        int heapMemory = this.taskManagerHeapMemorySizeMB + (this.taskResourceProfile.getHeapMemoryInMB() > 0 ? this.taskResourceProfile.getHeapMemoryInMB() * this.slotNum : this.defaultHeapMemMB);
        if (!this.offHeap) {
            heapMemory += this.getManagedMemorySize() + this.getFloatingManagedMemorySize();
        }
        return heapMemory;
    }

    public int getTotalDirectMemory() {
        int directMemory = this.taskManagerNettyMemorySizeMB + this.taskResourceProfile.getDirectMemoryInMB() * this.slotNum + this.getNetworkMemorySize();
        if (this.offHeap) {
            directMemory += this.getManagedMemorySize() + this.getFloatingManagedMemorySize();
        }
        return directMemory;
    }

    public int getYoungHeapMemory() {
        int dynamicMemory = this.getDynamicHeapMemory();
        int persistentMemory = this.getPersistentHeapMemory();
        return (int)Math.max((double)dynamicMemory * this.dynamicYoungHeapRatio, (double)persistentMemory * this.persistentYoungHeapRatio);
    }

    private int getPersistentHeapMemory() {
        int persistentMemory = 0;
        if (!this.offHeap && this.managedMemoryPreAllocate) {
            persistentMemory += this.getManagedMemorySize() + this.getFloatingManagedMemorySize();
        }
        return persistentMemory;
    }

    private int getDynamicHeapMemory() {
        return this.getTotalHeapMemory() - this.getPersistentHeapMemory();
    }

    public int getSlotNum() {
        return this.slotNum;
    }

    public ResourceProfile getTaskResourceProfile() {
        int userHeap = this.taskResourceProfile.getHeapMemoryInMB();
        if (this.taskManagerTotalMemoryMB > 0) {
            userHeap = this.offHeap ? this.getTotalHeapMemory() - this.taskManagerHeapMemorySizeMB : this.getTotalHeapMemory() - this.taskManagerHeapMemorySizeMB - this.getManagedMemorySize() - this.getFloatingManagedMemorySize();
        }
        return new ResourceProfile(this.taskResourceProfile.getCpuCores(), userHeap, this.taskResourceProfile.getDirectMemoryInMB(), this.taskResourceProfile.getNativeMemoryInMB(), this.taskResourceProfile.getNetworkMemoryInMB(), this.taskResourceProfile.getExtendedResources(), this.taskResourceProfile.getResourceConstraints());
    }

    public double getContainerCpuCores() {
        return this.taskResourceProfile.getCpuCores() * (double)this.slotNum;
    }

    public static TaskManagerResource fromConfiguration(Configuration configuration, ResourceProfile resourceProfile, int slotNum, int taskManagerTotalMemorySize) {
        int taskManagerNettyMemorySizeMB = configuration.getInteger(TaskManagerOptions.TASK_MANAGER_PROCESS_NETTY_MEMORY);
        int taskManagerNativeMemorySizeMB = configuration.getInteger(TaskManagerOptions.TASK_MANAGER_PROCESS_NATIVE_MEMORY);
        int taskManagerHeapMemorySizeMB = configuration.getInteger(TaskManagerOptions.TASK_MANAGER_PROCESS_HEAP_MEMORY);
        double dynamicYoungRatio = configuration.getDouble(TaskManagerOptions.TASK_MANAGER_MEMORY_DYNAMIC_YOUNG_RATIO);
        double persistentYoungRatio = configuration.getDouble(TaskManagerOptions.TASK_MANAGER_MEMORY_PERSISTENT_YOUNG_RATIO);
        float managedMemoryFraction = configuration.getFloat(TaskManagerOptions.MANAGED_MEMORY_FRACTION);
        boolean useOffHeap = configuration.getBoolean(TaskManagerOptions.MEMORY_OFF_HEAP);
        boolean preAllocate = configuration.getBoolean(TaskManagerOptions.MANAGED_MEMORY_PRE_ALLOCATE);
        int defaultNetworkMemMB = (int)Math.ceil((double)TaskManagerResourceCalculator.calculateNetworkBufferMemory(configuration) / 1048576.0);
        int defaultHeapMemMB = configuration.getInteger(TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY);
        return new TaskManagerResource(taskManagerNettyMemorySizeMB, taskManagerNativeMemorySizeMB, taskManagerHeapMemorySizeMB, managedMemoryFraction, useOffHeap, preAllocate, defaultNetworkMemMB, defaultHeapMemMB, dynamicYoungRatio, persistentYoungRatio, resourceProfile, slotNum, taskManagerTotalMemorySize);
    }

    public static TaskManagerResource fromConfiguration(Configuration configuration, ResourceProfile resourceProfile, int slotNum) {
        return TaskManagerResource.fromConfiguration(configuration, resourceProfile, slotNum, -1);
    }

    public int hashCode() {
        return Objects.hash(this.taskManagerNettyMemorySizeMB, this.offHeap, this.taskManagerNativeMemorySizeMB, this.taskManagerHeapMemorySizeMB, this.dynamicYoungHeapRatio, this.persistentYoungHeapRatio, this.taskResourceProfile, this.slotNum);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == TaskManagerResource.class) {
            TaskManagerResource that = (TaskManagerResource)obj;
            return this.taskResourceProfile.equals(that.taskResourceProfile) && this.taskManagerNettyMemorySizeMB == that.taskManagerNettyMemorySizeMB && this.taskManagerNativeMemorySizeMB == that.taskManagerNativeMemorySizeMB && this.taskManagerHeapMemorySizeMB == that.taskManagerHeapMemorySizeMB && this.offHeap == that.offHeap && this.managedMemoryFraction == that.managedMemoryFraction && this.slotNum == that.slotNum && this.dynamicYoungHeapRatio == that.dynamicYoungHeapRatio && this.persistentYoungHeapRatio == that.persistentYoungHeapRatio;
        }
        return false;
    }

    public String toString() {
        return "TaskManagerResource {taskManagerTotalMemoryMB=" + this.taskManagerTotalMemoryMB + ", taskResourceProfile=" + this.getTaskResourceProfile() + ", taskManagerNettyMemoryInMB=" + this.taskManagerNettyMemorySizeMB + ", taskManagerNativeMemorySizeMB=" + this.taskManagerNativeMemorySizeMB + ", taskManagerHeapMemorySizeMB=" + this.taskManagerHeapMemorySizeMB + ", dynamicYoungRatio=" + this.dynamicYoungHeapRatio + ", persistentYoungRatio=" + this.persistentYoungHeapRatio + ", offHeap=" + this.offHeap + ", slotNum=" + this.slotNum + '}';
    }
}

