/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import org.apache.flink.runtime.deployment.InputChannelDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.deployment.ResultPartitionLocationTrackerProxy;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class PartialInputChannelDeploymentDescriptor {
    private final IntermediateResult intermediateResult;
    private final ResultPartitionID partitionID;
    private final TaskManagerLocation partitionTaskManagerLocation;

    public PartialInputChannelDeploymentDescriptor(IntermediateResult intermediateResult, ResultPartitionID partitionID, TaskManagerLocation partitionTaskManagerLocation) {
        this.intermediateResult = (IntermediateResult)Preconditions.checkNotNull((Object)intermediateResult);
        this.partitionID = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionID);
        this.partitionTaskManagerLocation = (TaskManagerLocation)Preconditions.checkNotNull((Object)partitionTaskManagerLocation);
    }

    public InputChannelDeploymentDescriptor createInputChannelDeploymentDescriptor(Execution consumerExecution, ResultPartitionLocationTrackerProxy resultPartitionLocationTrackerProxy) {
        Preconditions.checkNotNull((Object)consumerExecution, (String)"consumerExecution");
        TaskManagerLocation consumerLocation = consumerExecution.getAssignedResourceLocation();
        Preconditions.checkNotNull((Object)consumerLocation, (String)"Consumer connection info null");
        ResultPartitionLocation partitionLocation = resultPartitionLocationTrackerProxy.getResultPartitionLocation(this.partitionTaskManagerLocation, consumerLocation, this.intermediateResult);
        return new InputChannelDeploymentDescriptor(this.partitionID, partitionLocation);
    }

    public IntermediateDataSetID getResultId() {
        return this.intermediateResult.getId();
    }

    public static PartialInputChannelDeploymentDescriptor fromEdge(IntermediateResultPartition partition, Execution producer) {
        ResultPartitionID partitionId = new ResultPartitionID(partition.getPartitionId(), producer.getAttemptId());
        IntermediateResult result = partition.getIntermediateResult();
        TaskManagerLocation partitionConnectionInfo = producer.getAssignedResourceLocation();
        return new PartialInputChannelDeploymentDescriptor(result, partitionId, partitionConnectionInfo);
    }
}

