/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.dispatcher.ArchivedExecutionGraphStore;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.HistoryServerArchivist;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.metrics.groups.JobManagerMetricGroup;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.LeaderShipLostHandler;
import org.apache.flink.runtime.rpc.RpcService;

public class DriverDispatcher
extends Dispatcher {
    private Map<JobID, Integer> dispatcherManagerPriorityMap = new HashMap<JobID, Integer>();

    public DriverDispatcher(RpcService rpcService, String endpointId, Configuration configuration, HighAvailabilityServices highAvailabilityServices, ResourceManagerGateway resourceManagerGateway, BlobServer blobServer, HeartbeatServices heartbeatServices, JobManagerMetricGroup jobManagerMetricGroup, @Nullable String metricServiceQueryPath, ArchivedExecutionGraphStore archivedExecutionGraphStore, Dispatcher.JobManagerRunnerFactory jobManagerRunnerFactory, FatalErrorHandler fatalErrorHandler, @Nullable String restAddress, HistoryServerArchivist historyServerArchivist, LeaderShipLostHandler leaderShipLostHandler) throws Exception {
        super(rpcService, endpointId, configuration, highAvailabilityServices, highAvailabilityServices.getSubmittedJobGraphStore(), resourceManagerGateway, blobServer, heartbeatServices, jobManagerMetricGroup, metricServiceQueryPath, archivedExecutionGraphStore, jobManagerRunnerFactory, fatalErrorHandler, restAddress, historyServerArchivist, leaderShipLostHandler);
        this.log.info("Initiating DriverDispatcher Instance.");
    }

    @Override
    public CompletableFuture<Acknowledge> submitJob(JobGraph jobGraph, Time timeout) {
        Integer dispatcherManagePriority = jobGraph.getJobConfiguration().getInteger("flink.driver.manage.priority", 1);
        this.log.info("submit new job, jobId: " + jobGraph.getJobID());
        this.log.info("flink.driver.manage.priority: " + dispatcherManagePriority);
        this.dispatcherManagerPriorityMap.put(jobGraph.getJobID(), dispatcherManagePriority);
        return super.submitJob(jobGraph, timeout);
    }

    @Override
    protected void jobReachedGloballyTerminalState(ArchivedExecutionGraph archivedExecutionGraph) {
        this.log.info("Job: " + archivedExecutionGraph.getJobName() + " Reached GloballyTerminalState.");
        super.jobReachedGloballyTerminalState(archivedExecutionGraph);
        int jobDispatcherManagePriority = this.dispatcherManagerPriorityMap.get(archivedExecutionGraph.getJobID());
        if (jobDispatcherManagePriority == 0 && archivedExecutionGraph.getState().equals((Object)JobStatus.FAILED)) {
            this.log.error("Driver Job FAILED, terminate driverDispatcher.");
            this.getTerminationFuture().complete(null);
            return;
        }
        CompletableFuture<ClusterOverview> clusterOverview = this.requestClusterOverview(Time.seconds((long)30000L));
        clusterOverview.thenApply(overview -> {
            int numJobsRunning = overview.getNumJobsRunningOrPending();
            if (numJobsRunning == 0) {
                this.log.info("All jobs finished, terminate driverDispatcher.");
                this.getTerminationFuture().complete(null);
            }
            return null;
        });
    }

    @Override
    protected void jobNotFinished(JobID jobId) {
        super.jobNotFinished(jobId);
        int jobDispatcherManagePriority = this.dispatcherManagerPriorityMap.get(jobId);
        if (jobDispatcherManagePriority == 0) {
            this.log.error("Driver Job FAILED, terminate driverDispatcher.");
            this.getTerminationFuture().complete(null);
        }
    }
}

