/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class IntermediateResult {
    private final IntermediateDataSetID id;
    private final ExecutionJobVertex producer;
    private final IntermediateResultPartition[] partitions;
    private final HashMap<IntermediateResultPartitionID, Integer> partitionLookupHelper = new HashMap();
    private final int numParallelProducers;
    private int partitionsAssigned;
    private int numConsumers;
    private final int connectionIndex;
    private ResultPartitionType resultType;
    private final AtomicInteger numberOfConsumablePartitions = new AtomicInteger();

    public IntermediateResult(IntermediateDataSetID id, ExecutionJobVertex producer, int numParallelProducers, ResultPartitionType resultType) {
        this.id = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)id)));
        this.producer = (ExecutionJobVertex)Preconditions.checkNotNull((Object)producer);
        Preconditions.checkArgument((numParallelProducers >= 1 ? 1 : 0) != 0);
        this.numParallelProducers = numParallelProducers;
        this.partitions = new IntermediateResultPartition[numParallelProducers];
        this.connectionIndex = (int)(Math.random() * 2.147483647E9);
        this.resultType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)resultType)));
    }

    public void resetLookupHelper(IntermediateResultPartitionID originId, IntermediateResultPartitionID newId) {
        Integer partitionNumber = this.partitionLookupHelper.remove((Object)originId);
        if (partitionNumber == null) {
            throw new FlinkRuntimeException("Fail to find origin partition " + (Object)((Object)originId));
        }
        this.partitionLookupHelper.put(newId, partitionNumber);
    }

    public void setPartition(int partitionNumber, IntermediateResultPartition partition) {
        if (partition == null || partitionNumber < 0 || partitionNumber >= this.numParallelProducers) {
            throw new IllegalArgumentException();
        }
        if (this.partitions[partitionNumber] != null) {
            throw new IllegalStateException("Partition #" + partitionNumber + " has already been assigned.");
        }
        this.partitions[partitionNumber] = partition;
        this.partitionLookupHelper.put(partition.getPartitionId(), partitionNumber);
        ++this.partitionsAssigned;
    }

    public IntermediateDataSetID getId() {
        return this.id;
    }

    public ExecutionJobVertex getProducer() {
        return this.producer;
    }

    public IntermediateResultPartition[] getPartitions() {
        return this.partitions;
    }

    public IntermediateResultPartition getPartitionOrNullById(IntermediateResultPartitionID resultPartitionId) {
        Integer partitionNumber = this.partitionLookupHelper.get(Preconditions.checkNotNull((Object)((Object)resultPartitionId), (String)"IntermediateResultPartitionID"));
        if (partitionNumber != null) {
            return this.partitions[partitionNumber];
        }
        return null;
    }

    public IntermediateResultPartition getPartitionById(IntermediateResultPartitionID resultPartitionId) {
        IntermediateResultPartition partition = this.getPartitionOrNullById(resultPartitionId);
        if (partition == null) {
            throw new IllegalArgumentException("Unknown intermediate result partition ID " + (Object)((Object)resultPartitionId));
        }
        return partition;
    }

    public int getNumberOfAssignedPartitions() {
        return this.partitionsAssigned;
    }

    public ResultPartitionType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultPartitionType resultType) {
        this.resultType = resultType;
    }

    public int registerConsumer() {
        int index = this.numConsumers++;
        for (IntermediateResultPartition p : this.partitions) {
            if (p.addConsumerGroup() == index) continue;
            throw new RuntimeException("Inconsistent consumer mapping between intermediate result partitions.");
        }
        return index;
    }

    public int getConnectionIndex() {
        return this.connectionIndex;
    }

    public int incrementNumberOfConsumablePartitions() {
        return this.numberOfConsumablePartitions.incrementAndGet();
    }

    public int decrementNumberOfConsumablePartitions() {
        return this.numberOfConsumablePartitions.decrementAndGet();
    }

    public double getResultConsumablePartitionRatio() {
        return 1.0 * (double)this.numberOfConsumablePartitions.get() / (double)this.numParallelProducers;
    }

    public String toString() {
        return "IntermediateResult " + this.id.toString();
    }
}

