/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover;

import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.executiongraph.failover.FailoverStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartAllStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartIndividualStrategy;
import org.apache.flink.runtime.executiongraph.failover.RestartPipelinedRegionStrategy;
import org.apache.flink.runtime.executiongraph.failover.StrictRestartPipelinedRegionStrategy;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;

public class FailoverStrategyLoader {
    public static final String FULL_RESTART_STRATEGY_NAME = "full";
    public static final String INDIVIDUAL_RESTART_STRATEGY_NAME = "individual";
    public static final String PIPELINED_REGION_RESTART_STRATEGY_NAME = "region";

    public static FailoverStrategy.Factory loadFailoverStrategy(JobGraph jobGraph, Configuration config, ClassLoader userClassLoader, @Nullable Logger logger) {
        String strategyParam = config.getString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY);
        if (StringUtils.isNullOrWhitespaceOnly((String)strategyParam)) {
            if (logger != null) {
                logger.warn("Null config value for {} ; using default failover strategy (full restarts).", (Object)JobManagerOptions.EXECUTION_FAILOVER_STRATEGY.key());
            }
            return new RestartAllStrategy.Factory();
        }
        switch (strategyParam.toLowerCase()) {
            case "full": {
                return new RestartAllStrategy.Factory();
            }
            case "region": {
                int regionFailLimit = config.getInteger(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY_REGION_MAX_ATTEMPTS);
                if (jobGraph.hasNonDeterministicShuffles()) {
                    StrictRestartPipelinedRegionStrategy.Factory factory = new StrictRestartPipelinedRegionStrategy.Factory();
                    factory.setRegionFailLimit(regionFailLimit);
                    return factory;
                }
                RestartPipelinedRegionStrategy.Factory factory = new RestartPipelinedRegionStrategy.Factory();
                factory.setRegionFailLimit(regionFailLimit);
                return factory;
            }
            case "individual": {
                int taskFailuresDetectTimeSpan = config.getInteger(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY_INDIVIDUAL_TASK_FAILURES_DETECT_TIME_SPAN);
                int taskFailuresLimit = config.getInteger(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY_INDIVIDUAL_TASK_FAILURES_LIMIT);
                RestartIndividualStrategy.Factory restartIndividualStrategyFactory = new RestartIndividualStrategy.Factory(taskFailuresDetectTimeSpan, taskFailuresLimit);
                return restartIndividualStrategyFactory;
            }
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(userClassLoader);
        try {
            Object factoryObject = Class.forName(strategyParam).newInstance();
            Preconditions.checkState((boolean)(factoryObject instanceof FailoverStrategy.Factory));
            FailoverStrategy.Factory factory = (FailoverStrategy.Factory)factoryObject;
            return factory;
        }
        catch (Exception e) {
            throw new IllegalConfigurationException("Unknown failover strategy: " + strategyParam);
        }
        finally {
            currentThread.setContextClassLoader(oldContextClassLoader);
        }
    }
}

