/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.resources.Resource;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.RestClientConfiguration;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingStatusMessageParameters;
import org.apache.flink.runtime.rest.handler.job.rescaling.UpdatingStatusHeaders;
import org.apache.flink.runtime.rest.handler.job.rescaling.UpdatingTriggerHeaders;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.ExecutionVertexIDInfo;
import org.apache.flink.runtime.rest.messages.JobExceptionsHeaders;
import org.apache.flink.runtime.rest.messages.JobExceptionsInfo;
import org.apache.flink.runtime.rest.messages.JobGraphOverviewHeaders;
import org.apache.flink.runtime.rest.messages.JobGraphOverviewInfo;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.JobsOverviewHeaders;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResourceSpecInfo;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.runtime.rest.messages.TotalResourceLimitExceptionInfosHeaders;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointMessageParameters;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatisticDetailsHeaders;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointingStatistics;
import org.apache.flink.runtime.rest.messages.checkpoints.CheckpointingStatisticsHeaders;
import org.apache.flink.runtime.rest.messages.job.JobAllSubtaskCurrentAttemptsInfoHeaders;
import org.apache.flink.runtime.rest.messages.job.JobExceptionsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptInfo;
import org.apache.flink.runtime.rest.messages.job.UpdatingJobRequest;
import org.apache.flink.runtime.rest.messages.job.metrics.ComponentMetric;
import org.apache.flink.runtime.rest.messages.job.metrics.ComponentsMetricCollectionResponseBody;
import org.apache.flink.runtime.rest.messages.job.metrics.JobTaskManagersComponentMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobTaskManagersComponentMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexSubtasksComponentMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.JobVertexSubtasksComponentMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.job.metrics.Metric;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagersComponentMetricsHeaders;
import org.apache.flink.runtime.rest.messages.job.metrics.TaskManagersComponentMetricsMessageParameters;
import org.apache.flink.runtime.rest.messages.queue.AsynchronouslyCreatedResource;
import org.apache.flink.runtime.rest.messages.queue.QueueStatus;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerExceptionsHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerExceptionsInfos;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerExecutionVertexIdsInfo;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskManagerMessageParameters;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskmanagerAllSubtaskCurrentAttemptsInfoHeaders;
import org.apache.flink.runtime.rest.messages.taskmanager.TaskmanagersAllSubtaskCurrentAttemptsInfoHeaders;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServerClientImpl
implements RestServerClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServerClientImpl.class);
    private RestClient restClient;
    private URI baseUri;
    private ScheduledExecutorService retryExecutorService;

    public RestServerClientImpl(String baseUrl, Configuration config, Executor executor) throws Exception {
        RestClientConfiguration restClientConfiguration = RestClientConfiguration.fromConfiguration(config);
        this.restClient = new RestClient(restClientConfiguration, executor);
        this.baseUri = new URI(baseUrl);
        this.retryExecutorService = Executors.newSingleThreadScheduledExecutor(new ExecutorThreadFactory("Flink-HealthManager-RestServerClient"));
    }

    public <M extends MessageHeaders<R, P, U>, U extends MessageParameters, R extends RequestBody, P extends ResponseBody> CompletableFuture<P> sendRequest(M messageHeaders, U messageParameters, R request) throws IOException {
        return this.restClient.sendRequest(this.baseUri.getHost(), this.baseUri.getPort(), messageHeaders, messageParameters, request, Collections.emptyList());
    }

    @Override
    public List<JobStatusMessage> listJob() throws Exception {
        return (List)((CompletableFuture)this.sendRequest(JobsOverviewHeaders.getInstance(), EmptyMessageParameters.getInstance(), EmptyRequestBody.getInstance()).thenApply(multipleJobsDetails -> {
            if (multipleJobsDetails != null && multipleJobsDetails.getJobs().size() > 0) {
                return multipleJobsDetails.getJobs().stream().map(detail -> new JobStatusMessage(detail.getJobId(), detail.getJobName(), detail.getStatus(), detail.getStartTime())).collect(Collectors.toList());
            }
            return new ArrayList();
        })).get();
    }

    @Override
    public RestServerClient.JobConfig getJobConfig(JobID jobId) {
        JobGraphOverviewHeaders header = JobGraphOverviewHeaders.getInstance();
        JobMessageParameters parameters = header.getUnresolvedMessageParameters();
        parameters.jobPathParameter.resolve(jobId);
        parameters.isResolved();
        try {
            return (RestServerClient.JobConfig)((CompletableFuture)this.sendRequest(header, parameters, EmptyRequestBody.getInstance()).thenApply(jobGraphOverviewInfo -> {
                HashMap<JobVertexID, RestServerClient.VertexConfig> vertexConfigs = new HashMap<JobVertexID, RestServerClient.VertexConfig>();
                HashMap<JobVertexID, List<Tuple2<JobVertexID, String>>> inputNodes = new HashMap<JobVertexID, List<Tuple2<JobVertexID, String>>>();
                for (Map.Entry<String, JobGraphOverviewInfo.VertexConfigInfo> vertexId2Config : jobGraphOverviewInfo.getVertexConfigs().entrySet()) {
                    JobGraphOverviewInfo.VertexConfigInfo jobGraphVertexConfig = vertexId2Config.getValue();
                    JobVertexID vertexID = JobVertexID.fromHexString(vertexId2Config.getKey());
                    RestServerClient.VertexConfig vertexConfig = new RestServerClient.VertexConfig(jobGraphVertexConfig.getName(), jobGraphVertexConfig.getParallelism(), jobGraphVertexConfig.getMaxParallelism(), jobGraphVertexConfig.getResourceSpec().convertToResourceSpec(), jobGraphVertexConfig.getNodeIds(), jobGraphVertexConfig.getCoLocationGroupId());
                    vertexConfigs.put(vertexID, vertexConfig);
                    List inputVertexIds = jobGraphOverviewInfo.getInputNodes().get(vertexId2Config.getKey()).stream().map(vertexId2ship -> Tuple2.of((Object)((Object)JobVertexID.fromHexString(vertexId2ship.getInputVertexId())), (Object)vertexId2ship.getShipStrategyName())).collect(Collectors.toList());
                    inputNodes.put(vertexID, inputVertexIds);
                }
                Configuration configuration = new Configuration();
                if (jobGraphOverviewInfo.getConfig() != null) {
                    configuration.addAll(jobGraphOverviewInfo.getConfig());
                }
                return new RestServerClient.JobConfig(configuration, vertexConfigs, inputNodes);
            })).get();
        }
        catch (Exception ignore) {
            return null;
        }
    }

    @Override
    public RestServerClient.JobStatus getJobStatus(JobID jobId) throws Exception {
        JobAllSubtaskCurrentAttemptsInfoHeaders headers = JobAllSubtaskCurrentAttemptsInfoHeaders.getInstance();
        JobMessageParameters parameters = headers.getUnresolvedMessageParameters();
        parameters.jobPathParameter.resolve(jobId);
        return (RestServerClient.JobStatus)((CompletableFuture)this.sendRequest(headers, parameters, EmptyRequestBody.getInstance()).thenApply(subtasksInfo -> {
            Collection<SubtaskExecutionAttemptInfo> subtasks = subtasksInfo.getSubtaskInfos();
            HashMap<ExecutionVertexID, Tuple2<Long, ExecutionState>> taskStatus = new HashMap<ExecutionVertexID, Tuple2<Long, ExecutionState>>();
            for (SubtaskExecutionAttemptInfo subtask : subtasks) {
                JobVertexID jobVertexID = JobVertexID.fromHexString(subtask.getVertexId());
                ExecutionVertexID executionVertexID = new ExecutionVertexID(jobVertexID, subtask.getSubtaskIndex());
                taskStatus.put(executionVertexID, (Tuple2<Long, ExecutionState>)Tuple2.of((Object)subtask.getCurrentStateTime(), (Object)((Object)subtask.getStatus())));
            }
            return new RestServerClient.JobStatus(taskStatus);
        })).get();
    }

    @Override
    public Map<JobVertexID, List<JobException>> getFailover(JobID jobID, long startTime, long endTime) throws Exception {
        JobExceptionsHeaders headers = JobExceptionsHeaders.getInstance();
        JobExceptionsMessageParameters parameters = headers.getUnresolvedMessageParameters();
        parameters.jobPathParameter.resolve(jobID);
        ArrayList<Long> startList = new ArrayList<Long>();
        startList.add(startTime);
        ArrayList<Long> endList = new ArrayList<Long>();
        endList.add(endTime);
        parameters.start.resolve(startList);
        parameters.end.resolve(endList);
        Map failovers = (Map)((CompletableFuture)this.sendRequest(headers, parameters, EmptyRequestBody.getInstance()).thenApply(exceptionsInfo -> {
            List<JobExceptionsInfo.ExecutionExceptionInfo> exceptions = exceptionsInfo.getAllExceptions();
            HashMap jobVertexId2exceptions = new HashMap();
            for (JobExceptionsInfo.ExecutionExceptionInfo exception : exceptions) {
                JobVertexID jobVertexID = JobVertexID.fromHexString(exception.getVertexID());
                JobException vertexException = new JobException(exception.getException());
                List vertexExceptions = jobVertexId2exceptions.containsKey((Object)jobVertexID) ? (List)jobVertexId2exceptions.get((Object)jobVertexID) : new ArrayList();
                vertexExceptions.add(vertexException);
                jobVertexId2exceptions.put(jobVertexID, vertexExceptions);
            }
            return jobVertexId2exceptions;
        })).get();
        LOGGER.debug("get failovers of job {} from {} to {} : {}.", new Object[]{jobID, new Date(startTime).toString(), new Date(endTime).toString(), failovers});
        return failovers;
    }

    @Override
    public List<ExecutionVertexID> getTaskManagerTasks(String tmId) {
        TaskmanagerAllSubtaskCurrentAttemptsInfoHeaders header = TaskmanagerAllSubtaskCurrentAttemptsInfoHeaders.getInstance();
        TaskManagerMessageParameters parameters = header.getUnresolvedMessageParameters();
        ResourceID resourceId = new ResourceID(tmId);
        parameters.taskManagerIdParameter.resolve(resourceId);
        ArrayList<ExecutionVertexID> executionVertexIDs = new ArrayList<ExecutionVertexID>();
        try {
            ((CompletableFuture)this.sendRequest(header, parameters, EmptyRequestBody.getInstance()).thenApply(taskManagerExecutionVertexIdsInfo -> {
                List<ExecutionVertexIDInfo> executionVertexIDInfos = taskManagerExecutionVertexIdsInfo.getExecutionVertexIds();
                if (executionVertexIDInfos != null && !executionVertexIDInfos.isEmpty()) {
                    executionVertexIDs.addAll(executionVertexIDInfos.stream().map(ExecutionVertexIDInfo::convertToResourceSpec).collect(Collectors.toList()));
                }
                return executionVertexIDs;
            })).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return executionVertexIDs;
    }

    @Override
    public Map<String, List<ExecutionVertexID>> getAllTaskManagerTasks() {
        TaskmanagersAllSubtaskCurrentAttemptsInfoHeaders headers = TaskmanagersAllSubtaskCurrentAttemptsInfoHeaders.getInstance();
        EmptyMessageParameters param = headers.getUnresolvedMessageParameters();
        HashMap<String, List<ExecutionVertexID>> result = new HashMap<String, List<ExecutionVertexID>>();
        try {
            ((CompletableFuture)this.sendRequest(headers, param, EmptyRequestBody.getInstance()).thenApply(taskManagersExecutionVertexIdsInfo -> {
                Map<String, TaskManagerExecutionVertexIdsInfo> id2ExecutionVertexIds = taskManagersExecutionVertexIdsInfo.getExecutionVertexIds();
                for (Map.Entry<String, TaskManagerExecutionVertexIdsInfo> id2ExecutionVertexId : id2ExecutionVertexIds.entrySet()) {
                    List<ExecutionVertexIDInfo> executionVertexIDInfos = id2ExecutionVertexId.getValue().getExecutionVertexIds();
                    ArrayList executionVertexIDs = new ArrayList();
                    if (executionVertexIDInfos != null && !executionVertexIDInfos.isEmpty()) {
                        executionVertexIDs.addAll(executionVertexIDInfos.stream().map(ExecutionVertexIDInfo::convertToResourceSpec).collect(Collectors.toList()));
                    }
                    result.put(id2ExecutionVertexId.getKey(), executionVertexIDs);
                }
                return result;
            })).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Map<String, Map<Integer, Tuple2<Long, Double>>> getTaskMetrics(JobID jobID, JobVertexID jobVertexID, Set<String> metricNames) {
        JobVertexSubtasksComponentMetricsHeaders header = JobVertexSubtasksComponentMetricsHeaders.getInstance();
        JobVertexSubtasksComponentMetricsMessageParameters parameters = header.getUnresolvedMessageParameters();
        parameters.jobPathParameter.resolve(jobID);
        parameters.jobVertexIdPathParameter.resolve(jobVertexID);
        ArrayList<String> metricNameList = new ArrayList<String>();
        metricNameList.addAll(metricNames);
        parameters.metricsFilterParameter.resolve(metricNameList);
        HashMap<String, Map<Integer, Tuple2<Long, Double>>> result = new HashMap<String, Map<Integer, Tuple2<Long, Double>>>();
        LOGGER.debug("Task metrics request of {}:\n{}", (Object)jobVertexID, metricNameList);
        try {
            ((CompletableFuture)this.sendRequest(header, parameters, EmptyRequestBody.getInstance()).thenApply(cmc -> {
                Collection<ComponentMetric> componentMetrics = cmc.getComponentMetrics();
                for (ComponentMetric componentMetric : componentMetrics) {
                    Integer componentId = Integer.valueOf(componentMetric.getComponentId());
                    Long timestamp = componentMetric.getTimestamp();
                    for (Metric metric : componentMetric.getMetrics()) {
                        String metricName = metric.getId();
                        Double metricValue = Double.valueOf(metric.getValue());
                        HashMap<Integer, Tuple2> metricMap = (HashMap<Integer, Tuple2>)result.get(metric.getId());
                        if (metricMap == null) {
                            metricMap = new HashMap<Integer, Tuple2>(componentMetrics.size());
                        }
                        metricMap.put(componentId, Tuple2.of((Object)timestamp, (Object)metricValue));
                        result.put(metricName, metricMap);
                    }
                }
                return result;
            })).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.debug("Task metrics:\n" + result);
        return result;
    }

    @Override
    public Map<String, Map<String, Tuple2<Long, Double>>> getTaskManagerMetrics(Set<String> tmIds, Set<String> metricNames) {
        TaskManagersComponentMetricsHeaders header = TaskManagersComponentMetricsHeaders.getInstance();
        TaskManagersComponentMetricsMessageParameters parameters = header.getUnresolvedMessageParameters();
        ArrayList<String> metricNameList = new ArrayList<String>();
        metricNameList.addAll(metricNames);
        parameters.metricsFilterParameter.resolve(metricNameList);
        LOGGER.debug("Task Manager metrics request:\n" + metricNameList);
        HashMap<String, Map<String, Tuple2<Long, Double>>> result = new HashMap<String, Map<String, Tuple2<Long, Double>>>();
        try {
            ((CompletableFuture)this.sendRequest(header, parameters, EmptyRequestBody.getInstance()).thenApply(cmc -> this.updateMetricFromComponentsMetricCollection((ComponentsMetricCollectionResponseBody)cmc, (Map<String, Map<String, Tuple2<Long, Double>>>)result))).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.debug("Task Manager metrics:\n" + result);
        return result;
    }

    @Override
    public Map<String, Map<String, Tuple2<Long, Double>>> getTaskManagerMetrics(JobID jobId, Set<String> metricNames) {
        JobTaskManagersComponentMetricsHeaders header = JobTaskManagersComponentMetricsHeaders.getInstance();
        JobTaskManagersComponentMetricsMessageParameters parameters = header.getUnresolvedMessageParameters();
        parameters.jobPathParameter.resolve(jobId);
        ArrayList<String> metricNameList = new ArrayList<String>();
        metricNameList.addAll(metricNames);
        parameters.metricsFilterParameter.resolve(metricNameList);
        LOGGER.debug("Task Manager metrics request:\n" + metricNameList);
        HashMap<String, Map<String, Tuple2<Long, Double>>> result = new HashMap<String, Map<String, Tuple2<Long, Double>>>();
        try {
            ((CompletableFuture)this.sendRequest(header, parameters, EmptyRequestBody.getInstance()).thenApply(cmc -> this.updateMetricFromComponentsMetricCollection((ComponentsMetricCollectionResponseBody)cmc, (Map<String, Map<String, Tuple2<Long, Double>>>)result))).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOGGER.debug("Task Manager metrics:\n" + result);
        return result;
    }

    @Override
    public CompletableFuture<Acknowledge> rescale(JobID jobId, Map<JobVertexID, Tuple2<Integer, ResourceSpec>> vertexParallelismResource) throws IOException {
        UpdatingTriggerHeaders header = UpdatingTriggerHeaders.getInstance();
        JobMessageParameters parameters = header.getUnresolvedMessageParameters();
        HashMap<String, UpdatingJobRequest.VertexResource> vertexParallelismResourceJsonMap = new HashMap<String, UpdatingJobRequest.VertexResource>();
        for (Map.Entry<JobVertexID, Tuple2<Integer, ResourceSpec>> id2resource : vertexParallelismResource.entrySet()) {
            String idStr = id2resource.getKey().toString();
            Tuple2<Integer, ResourceSpec> parallism2Resource = id2resource.getValue();
            ResourceSpec resourceSpec = (ResourceSpec)parallism2Resource.f1;
            Integer parallelism = (Integer)parallism2Resource.f0;
            HashMap<String, ResourceSpecInfo.ResourceInfo> extendedResource = new HashMap<String, ResourceSpecInfo.ResourceInfo>();
            if (resourceSpec.getExtendedResources().size() > 0) {
                for (Map.Entry name2Resource : resourceSpec.getExtendedResources().entrySet()) {
                    extendedResource.put((String)name2Resource.getKey(), new ResourceSpecInfo.ResourceInfo((Resource)name2Resource.getValue()));
                }
            }
            ResourceSpecInfo resourceSpecInfo = new ResourceSpecInfo(resourceSpec.getCpuCores(), resourceSpec.getHeapMemory(), resourceSpec.getDirectMemory(), resourceSpec.getNativeMemory(), resourceSpec.getStateSize(), extendedResource);
            vertexParallelismResourceJsonMap.put(idStr, new UpdatingJobRequest.VertexResource(parallelism, resourceSpecInfo));
        }
        UpdatingJobRequest updatingJobRequest = new UpdatingJobRequest(vertexParallelismResourceJsonMap);
        parameters.jobPathParameter.resolve(jobId);
        CompletableFuture updatingTriggerResponseFuture = this.sendRequest(header, parameters, updatingJobRequest);
        CompletionStage updatingOperationFuture = updatingTriggerResponseFuture.thenCompose(triggerResponse -> {
            TriggerId triggerId = triggerResponse.getTriggerId();
            UpdatingStatusHeaders updatingStatusHeaders = UpdatingStatusHeaders.getInstance();
            RescalingStatusMessageParameters rescalingStatusMessageParameters = updatingStatusHeaders.getUnresolvedMessageParameters();
            rescalingStatusMessageParameters.jobPathParameter.resolve(jobId);
            rescalingStatusMessageParameters.triggerIdPathParameter.resolve(triggerId);
            return this.pollResourceAsync(() -> {
                try {
                    return this.sendRequest(updatingStatusHeaders, rescalingStatusMessageParameters, EmptyRequestBody.getInstance());
                }
                catch (IOException e) {
                    throw new CompletionException(e.getCause());
                }
            });
        });
        return ((CompletableFuture)updatingOperationFuture).thenApply(asynchronousOperationInfo -> {
            if (asynchronousOperationInfo.getFailureCause() == null) {
                return Acknowledge.get();
            }
            throw new CompletionException((Throwable)asynchronousOperationInfo.getFailureCause());
        });
    }

    @Override
    public Map<Long, Exception> getTotalResourceLimitExceptions() throws Exception {
        TotalResourceLimitExceptionInfosHeaders header = TotalResourceLimitExceptionInfosHeaders.getInstance();
        EmptyMessageParameters param = header.getUnresolvedMessageParameters();
        HashMap result = new HashMap();
        return (Map)((CompletableFuture)this.sendRequest(header, param, EmptyRequestBody.getInstance()).thenApply(totalResourceLimitInfos -> {
            Map<Long, Exception> totalResourceLimit = totalResourceLimitInfos.getResourceLimit();
            if (totalResourceLimit != null && !totalResourceLimit.isEmpty()) {
                result.putAll(totalResourceLimit);
            }
            return totalResourceLimit;
        })).get();
    }

    @Override
    public Map<String, List<Exception>> getTaskManagerExceptions(long startTime, long endTime) throws Exception {
        TaskManagerExceptionsHeaders header = TaskManagerExceptionsHeaders.getInstance();
        EmptyMessageParameters param = header.getUnresolvedMessageParameters();
        HashMap result = new HashMap();
        return (Map)((CompletableFuture)this.sendRequest(header, param, EmptyRequestBody.getInstance()).thenApply(taskManagerExceptionsInfos -> {
            Map<Long, TaskManagerExceptionsInfos.TaskManagerException> taskmanagerExceptions = taskManagerExceptionsInfos.getTaskmanagerExceptions();
            for (Map.Entry<Long, TaskManagerExceptionsInfos.TaskManagerException> time2Exception : taskmanagerExceptions.entrySet()) {
                if (time2Exception.getKey() < startTime || time2Exception.getKey() > endTime) continue;
                TaskManagerExceptionsInfos.TaskManagerException te = time2Exception.getValue();
                String tmId = te.getResourceId().getResourceIdString();
                if (!result.containsKey(tmId)) {
                    result.put(tmId, new ArrayList());
                }
                ((List)result.get(tmId)).add(te.getException());
            }
            return result;
        })).get();
    }

    @Override
    public CheckpointStatistics getLatestCheckPointStates(JobID jobId) throws Exception {
        CheckpointingStatisticsHeaders header = CheckpointingStatisticsHeaders.getInstance();
        JobMessageParameters param = header.getUnresolvedMessageParameters();
        param.jobPathParameter.resolve(jobId);
        CheckpointStatistics.CompletedCheckpointStatistics latestCheckpoints = ((CheckpointingStatistics)this.sendRequest(header, param, EmptyRequestBody.getInstance()).get()).getLatestCheckpoints().getCompletedCheckpointStatistics();
        if (latestCheckpoints != null) {
            Long latestCheckpointId = latestCheckpoints.getId();
            CheckpointStatisticDetailsHeaders checkpointStatisticDetailsHeaders = CheckpointStatisticDetailsHeaders.getInstance();
            CheckpointMessageParameters checkpointMessageParameters = checkpointStatisticDetailsHeaders.getUnresolvedMessageParameters();
            checkpointMessageParameters.jobPathParameter.resolve(jobId);
            checkpointMessageParameters.checkpointIdPathParameter.resolve(latestCheckpointId);
            return (CheckpointStatistics)this.sendRequest(checkpointStatisticDetailsHeaders, checkpointMessageParameters, EmptyRequestBody.getInstance()).get();
        }
        return null;
    }

    private Map<String, Map<String, Tuple2<Long, Double>>> updateMetricFromComponentsMetricCollection(ComponentsMetricCollectionResponseBody cmc, Map<String, Map<String, Tuple2<Long, Double>>> result) {
        Collection<ComponentMetric> componentMetrics = cmc.getComponentMetrics();
        for (ComponentMetric componentMetric : componentMetrics) {
            String componentId = componentMetric.getComponentId();
            Long timestamp = componentMetric.getTimestamp();
            for (Metric metric : componentMetric.getMetrics()) {
                String metricName = metric.getId();
                Double metricValue = Double.valueOf(metric.getValue());
                Map<String, Tuple2<Long, Double>> metricMap = result.get(metric.getId());
                if (metricMap == null) {
                    metricMap = new HashMap<String, Tuple2<Long, Double>>(componentMetrics.size());
                }
                metricMap.put(componentId, (Tuple2<Long, Double>)Tuple2.of((Object)timestamp, (Object)metricValue));
                result.put(metricName, metricMap);
            }
        }
        return result;
    }

    private <R, A extends AsynchronouslyCreatedResource<R>> CompletableFuture<R> pollResourceAsync(Supplier<CompletableFuture<A>> resourceFutureSupplier) {
        return this.pollResourceAsync(resourceFutureSupplier, new CompletableFuture(), 0L);
    }

    private <R, A extends AsynchronouslyCreatedResource<R>> CompletableFuture<R> pollResourceAsync(Supplier<CompletableFuture<A>> resourceFutureSupplier, CompletableFuture<R> resultFuture, long attempt) {
        resourceFutureSupplier.get().whenComplete((asynchronouslyCreatedResource, throwable) -> {
            if (throwable != null) {
                resultFuture.completeExceptionally((Throwable)throwable);
            } else if (asynchronouslyCreatedResource.queueStatus().getId() == QueueStatus.Id.COMPLETED) {
                resultFuture.complete(asynchronouslyCreatedResource.resource());
            } else {
                this.retryExecutorService.schedule(() -> this.lambda$null$16((Supplier)resourceFutureSupplier, resultFuture, attempt), attempt * 1000L + 1000L, TimeUnit.MILLISECONDS);
            }
        });
        return resultFuture;
    }

    private /* synthetic */ void lambda$null$16(Supplier resourceFutureSupplier, CompletableFuture resultFuture, long attempt) {
        this.pollResourceAsync(resourceFutureSupplier, resultFuture, attempt + 1L);
    }
}

