/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.MetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregatorDescriptor;

public class JobTMMetricSubscription
extends MetricSubscription<Map<String, Tuple2<Long, Double>>> {
    private JobID jobID;
    private Map<String, TimelineAggregator> tmAggregators = new HashMap<String, TimelineAggregator>();

    public JobTMMetricSubscription(JobID jobID, String metricName, TimelineAggregatorDescriptor timelineAggregatorDescriptor) {
        super(metricName, timelineAggregatorDescriptor);
        this.jobID = jobID;
    }

    @Override
    public Map<String, Tuple2<Long, Double>> getValue() {
        HashMap<String, Tuple2<Long, Double>> metricValues = new HashMap<String, Tuple2<Long, Double>>();
        for (Map.Entry<String, TimelineAggregator> entry : this.tmAggregators.entrySet()) {
            Tuple2<Long, Double> value = entry.getValue().getValue();
            if (value == null) continue;
            metricValues.put(entry.getKey(), value);
        }
        return metricValues;
    }

    @Override
    public Map<String, Tuple2<Long, Double>> getPartialValue() {
        HashMap<String, Tuple2<Long, Double>> metricValues = new HashMap<String, Tuple2<Long, Double>>();
        for (Map.Entry<String, TimelineAggregator> entry : this.tmAggregators.entrySet()) {
            Tuple2<Long, Double> value = entry.getValue().getPartialValue();
            if (value == null) continue;
            metricValues.put(entry.getKey(), value);
        }
        return metricValues;
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public void addValue(Map<String, Tuple2<Long, Double>> subtaskMetrics) {
        for (String tmId : subtaskMetrics.keySet()) {
            if (!this.tmAggregators.containsKey(tmId)) {
                this.tmAggregators.put(tmId, this.getTimelineAggregatorDescriptor().createTimelineAggregator());
            }
            this.tmAggregators.get(tmId).addValue(subtaskMetrics.get(tmId));
        }
        LinkedList<String> removedTM = new LinkedList<String>();
        for (String tmId : this.tmAggregators.keySet()) {
            if (subtaskMetrics.containsKey(tmId)) continue;
            removedTM.add(tmId);
        }
        for (String tmId : removedTM) {
            this.tmAggregators.remove(tmId);
        }
    }
}

