/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics;

import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggType;

public abstract class MetricAggFunction {
    public abstract Tuple2<Long, Double> getValue(List<Tuple2<Long, Double>> var1);

    public static MetricAggFunction getMetricAggFunction(MetricAggType aggType) {
        switch (aggType) {
            case SUM: {
                return Sum.SUM_FUNCTION;
            }
            case MIN: {
                return Min.MIN_FUNCTION;
            }
            case MAX: {
                return Max.MAX_FUNCTION;
            }
            case AVG: {
                return Avg.AVG_FUNCTION;
            }
        }
        throw new NotImplementedException("Agg type:" + (Object)((Object)aggType));
    }

    private static class Avg
    extends Sum {
        private static final Avg AVG_FUNCTION = new Avg();

        private Avg() {
        }

        @Override
        public Tuple2<Long, Double> getValue(List<Tuple2<Long, Double>> values) {
            Tuple2<Long, Double> sum = super.getValue(values);
            if (sum == null) {
                return sum;
            }
            return Tuple2.of((Object)sum.f0, (Object)((Double)sum.f1 / (double)values.size()));
        }
    }

    private static class Max
    extends MetricAggFunction {
        private static final Max MAX_FUNCTION = new Max();

        private Max() {
        }

        @Override
        public Tuple2<Long, Double> getValue(List<Tuple2<Long, Double>> values) {
            long timestamp = -1L;
            double value = Double.NEGATIVE_INFINITY;
            for (Tuple2<Long, Double> timestampAndValue : values) {
                if (timestampAndValue == null) {
                    return null;
                }
                if (timestamp == -1L) {
                    timestamp = (Long)timestampAndValue.f0;
                } else if (timestamp != (Long)timestampAndValue.f0) {
                    return null;
                }
                if (!(value < (Double)timestampAndValue.f1)) continue;
                value = (Double)timestampAndValue.f1;
            }
            if (timestamp == -1L) {
                return null;
            }
            return Tuple2.of((Object)timestamp, (Object)value);
        }
    }

    private static class Min
    extends MetricAggFunction {
        private static final Min MIN_FUNCTION = new Min();

        private Min() {
        }

        @Override
        public Tuple2<Long, Double> getValue(List<Tuple2<Long, Double>> values) {
            long timestamp = -1L;
            double value = Double.MAX_VALUE;
            for (Tuple2<Long, Double> timestampAndValue : values) {
                if (timestampAndValue == null) {
                    return null;
                }
                if (timestamp == -1L) {
                    timestamp = (Long)timestampAndValue.f0;
                } else if (timestamp != (Long)timestampAndValue.f0) {
                    return null;
                }
                if (!(value > (Double)timestampAndValue.f1)) continue;
                value = (Double)timestampAndValue.f1;
            }
            if (timestamp == -1L) {
                return null;
            }
            return Tuple2.of((Object)timestamp, (Object)value);
        }
    }

    private static class Sum
    extends MetricAggFunction {
        private static final Sum SUM_FUNCTION = new Sum();

        private Sum() {
        }

        @Override
        public Tuple2<Long, Double> getValue(List<Tuple2<Long, Double>> values) {
            long timestamp = -1L;
            double value = 0.0;
            for (Tuple2<Long, Double> timestampAndValue : values) {
                if (timestampAndValue == null) {
                    return null;
                }
                if (timestamp == -1L) {
                    timestamp = (Long)timestampAndValue.f0;
                } else if (timestamp != (Long)timestampAndValue.f0) {
                    return null;
                }
                value += ((Double)timestampAndValue.f1).doubleValue();
            }
            if (timestamp == -1L) {
                return null;
            }
            return Tuple2.of((Object)timestamp, (Object)value);
        }
    }
}

