/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class AvgTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private double sum = 0.0;
    private double count = 0.0;
    private long lastTimestamp = -1L;

    public AvgTimelineAggregator(long interval) {
        super(0L, interval);
    }

    public AvgTimelineAggregator(long startTime, long interval) {
        super(startTime, interval);
    }

    @Override
    public void updateTimestamp(long timestamp) {
        long intervalKey = this.getIntervalKey(timestamp);
        if (this.nextIntervalKey < intervalKey) {
            if (this.count > 0.0) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.sum / this.count;
            }
            this.nextIntervalKey = intervalKey;
            this.sum = 0.0;
            this.count = 0.0;
        }
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        if (this.lastTimestamp >= (Long)value.f0) {
            return;
        }
        this.lastTimestamp = (Long)value.f0;
        long intervalKey = this.getIntervalKey((Long)value.f0);
        if (this.nextIntervalKey == intervalKey) {
            this.sum += ((Double)value.f1).doubleValue();
            this.count += 1.0;
        } else if (this.nextIntervalKey < intervalKey) {
            if (this.count > 0.0) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.sum / this.count;
            }
            this.nextIntervalKey = intervalKey;
            this.sum = (Double)value.f1;
            this.count = 1.0;
        }
    }

    @Override
    public Tuple2<Long, Double> getPartialValue() {
        if (this.nextIntervalKey != -1L && this.count > 0.0) {
            return Tuple2.of((Object)this.nextIntervalKey, (Object)(this.sum / this.count));
        }
        return null;
    }
}

