/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class DeltaAvgTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private double sum = 0.0;
    private double count = 0.0;
    private long lastTimestamp = -1L;
    private double lastValue = 0.0;
    private long sampleInterval;

    public DeltaAvgTimelineAggregator(long interval) {
        super(0L, interval);
        this.sampleInterval = interval / 10L;
    }

    public DeltaAvgTimelineAggregator(long startTime, long interval) {
        super(startTime, interval);
        this.sampleInterval = interval / 10L;
    }

    @Override
    public void updateTimestamp(long timestamp) {
        long intervalKey = this.getIntervalKey(timestamp);
        if (this.nextIntervalKey < intervalKey) {
            if (this.count > 0.0) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.sum / this.count;
            }
            this.nextIntervalKey = intervalKey;
            this.sum = 0.0;
            this.count = 0.0;
        }
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        if (this.lastTimestamp >= (Long)value.f0) {
            return;
        }
        long intervalKey = this.getIntervalKey((Long)value.f0);
        if (this.lastTimestamp + this.sampleInterval <= (Long)value.f0) {
            double delta = (Double)value.f1 - this.lastValue;
            this.lastValue = (Double)value.f1;
            this.lastTimestamp = (Long)value.f0;
            if (this.nextIntervalKey == intervalKey) {
                this.sum += delta;
                this.count += 1.0;
            } else if (this.nextIntervalKey < intervalKey) {
                if (this.count > 0.0) {
                    this.currentTimestamp = this.nextIntervalKey;
                    this.currentValue = this.sum / this.count;
                }
                this.nextIntervalKey = intervalKey;
                this.sum = delta;
                this.count = 1.0;
            }
        } else if (this.nextIntervalKey < intervalKey) {
            if (this.count > 0.0) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.sum / this.count;
            }
            this.nextIntervalKey = intervalKey;
            this.sum = 0.0;
            this.count = 0.0;
        }
    }
}

