/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class EarliestTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private long lastTimestamp = Long.MAX_VALUE;
    private double lastValue = Double.NEGATIVE_INFINITY;

    public EarliestTimelineAggregator(long interval) {
        super(0L, interval);
    }

    public EarliestTimelineAggregator(long startTime, long interval) {
        super(startTime, interval);
    }

    @Override
    public void updateTimestamp(long timestamp) {
        long intervalKey = this.getIntervalKey(timestamp);
        if (this.nextIntervalKey < intervalKey) {
            if (this.lastTimestamp < Long.MAX_VALUE) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.lastValue;
            }
            this.nextIntervalKey = intervalKey;
            this.lastTimestamp = Long.MAX_VALUE;
        }
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        long intervalKey = this.getIntervalKey((Long)value.f0);
        if (this.nextIntervalKey == intervalKey) {
            if ((Long)value.f0 < this.lastTimestamp) {
                this.lastValue = (Double)value.f1;
                this.lastTimestamp = (Long)value.f0;
            }
        } else if (this.nextIntervalKey < intervalKey) {
            if (this.lastTimestamp < Long.MAX_VALUE) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.lastValue;
            }
            this.nextIntervalKey = intervalKey;
            this.lastValue = (Double)value.f1;
            this.lastTimestamp = (Long)value.f0;
        }
    }

    @Override
    public Tuple2<Long, Double> getPartialValue() {
        if (this.lastTimestamp < Long.MAX_VALUE) {
            return Tuple2.of((Object)this.nextIntervalKey, (Object)this.lastValue);
        }
        return null;
    }
}

