/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class MaxTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private double max = Double.NEGATIVE_INFINITY;

    public MaxTimelineAggregator(long interval) {
        super(0L, interval);
    }

    public MaxTimelineAggregator(long startTime, long interval) {
        super(startTime, interval);
    }

    @Override
    public void updateTimestamp(long timestamp) {
        long intervalKey = this.getIntervalKey(timestamp);
        if (this.nextIntervalKey < intervalKey) {
            if (this.max != Double.NEGATIVE_INFINITY) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.max;
            }
            this.nextIntervalKey = intervalKey;
            this.max = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        long intervalKey = this.getIntervalKey((Long)value.f0);
        if (this.nextIntervalKey == intervalKey && this.max < (Double)value.f1) {
            this.max = (Double)value.f1;
        } else if (this.nextIntervalKey < intervalKey) {
            if (this.max != Double.NEGATIVE_INFINITY) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.max;
            }
            this.nextIntervalKey = intervalKey;
            this.max = (Double)value.f1;
        }
    }

    @Override
    public Tuple2<Long, Double> getPartialValue() {
        if (this.nextIntervalKey != -1L && this.max != Double.NEGATIVE_INFINITY) {
            return Tuple2.of((Object)this.nextIntervalKey, (Object)this.max);
        }
        return null;
    }
}

