/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class RateTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private long maxTimestamp = -1L;
    private long minTimestamp = -1L;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.NEGATIVE_INFINITY;

    public RateTimelineAggregator(long interval) {
        super(0L, interval);
    }

    public RateTimelineAggregator(long startTime, long interval) {
        super(startTime, interval);
    }

    @Override
    public void updateTimestamp(long timestamp) {
        long intervalKey = this.getIntervalKey(timestamp);
        if (this.nextIntervalKey < intervalKey) {
            if (this.max != Double.NEGATIVE_INFINITY && this.min != Double.NEGATIVE_INFINITY && this.maxTimestamp != this.minTimestamp) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = (this.max - this.min) * 1000.0 / (double)(this.maxTimestamp - this.minTimestamp);
            }
            this.nextIntervalKey = intervalKey;
            this.max = Double.NEGATIVE_INFINITY;
            this.min = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        long intervalKey = this.getIntervalKey((Long)value.f0);
        if (this.nextIntervalKey == intervalKey) {
            if ((Long)value.f0 > this.maxTimestamp) {
                this.max = (Double)value.f1;
                this.maxTimestamp = (Long)value.f0;
            }
            if ((Long)value.f0 < this.minTimestamp) {
                this.min = (Double)value.f1;
                this.minTimestamp = (Long)value.f0;
            }
        } else if (this.nextIntervalKey < intervalKey) {
            if (this.max != Double.NEGATIVE_INFINITY && this.min != Double.NEGATIVE_INFINITY && this.maxTimestamp != this.minTimestamp) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = (this.max - this.min) * 1000.0 / (double)(this.maxTimestamp - this.minTimestamp);
            }
            this.nextIntervalKey = intervalKey;
            this.max = (Double)value.f1;
            this.maxTimestamp = (Long)value.f0;
            this.min = (Double)value.f1;
            this.minTimestamp = (Long)value.f0;
        }
    }
}

