/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.metrics.JobTMMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexFrequentFullGC;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrequentFullGCDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrequentFullGCDetector.class);
    private static final long MINUTE = 60000L;
    public static final ConfigOption<Integer> FULL_GC_COUNT_THRESHOLD = ConfigOptions.key((String)"healthmonitor.full-gc-detector.threshold.perMin").defaultValue((Object)5);
    public static final ConfigOption<Integer> FULL_GC_COUNT_SEVERE_THRESHOLD = ConfigOptions.key((String)"healthmonitor.full-gc-detector.severe-threshold.perMin").defaultValue((Object)10);
    public static final ConfigOption<Long> FULL_GC_CHECK_INTERVAL = ConfigOptions.key((String)"healthmonitor.full-gc-detector.interval.ms").defaultValue((Object)180000L);
    private JobID jobID;
    private RestServerClient restServerClient;
    private MetricProvider metricProvider;
    private HealthMonitor monitor;
    private int gcCountThreshold;
    private int gcCountSevereThreshold;
    private long gcCheckInterval;
    private JobTMMetricSubscription gcMetricSubscription;

    @Override
    public void open(HealthMonitor monitor) {
        this.monitor = monitor;
        this.jobID = monitor.getJobID();
        this.restServerClient = monitor.getRestServerClient();
        this.metricProvider = monitor.getMetricProvider();
        this.gcCheckInterval = monitor.getConfig().getLong(FULL_GC_CHECK_INTERVAL);
        this.gcCountThreshold = (int)((long)monitor.getConfig().getInteger(FULL_GC_COUNT_THRESHOLD) * (this.gcCheckInterval / 60000L));
        this.gcCountSevereThreshold = (int)((long)monitor.getConfig().getInteger(FULL_GC_COUNT_SEVERE_THRESHOLD) * (this.gcCheckInterval / 60000L));
        this.gcMetricSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.JVM.GarbageCollector.ConcurrentMarkSweep.Count", this.gcCheckInterval, TimelineAggType.RANGE);
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.gcMetricSubscription != null) {
            this.metricProvider.unsubscribe(this.gcMetricSubscription);
            this.gcMetricSubscription = null;
        }
    }

    @Override
    public Symptom detect() {
        boolean severe;
        LOGGER.debug("Start detecting.");
        Object gcCount = this.gcMetricSubscription.getValue();
        Object gcPartialCount = this.gcMetricSubscription.getPartialValue();
        if ((gcCount == null || gcCount.isEmpty()) && (gcPartialCount == null || gcPartialCount.isEmpty())) {
            return null;
        }
        HashSet<JobVertexID> jobVertexIDs = new HashSet<JobVertexID>();
        boolean bl = severe = this.checkGCThreshold((Map<String, Tuple2<Long, Double>>)gcCount, jobVertexIDs) || this.checkGCThreshold((Map<String, Tuple2<Long, Double>>)gcPartialCount, jobVertexIDs);
        if (jobVertexIDs != null && !jobVertexIDs.isEmpty()) {
            LOGGER.info("Frequent full gc detected for vertices {}.", jobVertexIDs);
            return new JobVertexFrequentFullGC(this.jobID, new ArrayList<JobVertexID>(jobVertexIDs), severe);
        }
        return null;
    }

    private boolean checkGCThreshold(Map<String, Tuple2<Long, Double>> gcCount, Set<JobVertexID> jobVertexIDs) {
        boolean severe = false;
        for (String tmId : gcCount.keySet()) {
            if (!MetricUtils.validateTmMetric(this.monitor, this.gcCheckInterval * 2L, gcCount.get(tmId))) {
                LOGGER.debug("Skip tm {}, metrics missing.", (Object)tmId);
                continue;
            }
            double deltaGCCount = (Double)gcCount.get((Object)tmId).f1;
            if (deltaGCCount > (double)this.gcCountThreshold) {
                List<ExecutionVertexID> jobExecutionVertexIds = this.restServerClient.getTaskManagerTasks(tmId);
                if (jobExecutionVertexIds != null) {
                    jobVertexIDs.addAll(jobExecutionVertexIds.stream().map(ExecutionVertexID::getJobVertexID).collect(Collectors.toList()));
                }
                if (deltaGCCount > (double)this.gcCountSevereThreshold) {
                    severe = true;
                }
            }
            LOGGER.debug("tm {} gc count {}", (Object)tmId, gcCount.get(tmId));
        }
        return severe;
    }
}

