/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexHeapOOM;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeapOOMDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeapOOMDetector.class);
    private JobID jobID;
    private RestServerClient restServerClient;
    private long lastDetectTime;

    @Override
    public void open(HealthMonitor monitor) {
        this.jobID = monitor.getJobID();
        this.restServerClient = monitor.getRestServerClient();
        this.lastDetectTime = System.currentTimeMillis();
    }

    @Override
    public void close() {
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        long now = System.currentTimeMillis();
        Map<JobVertexID, List<JobException>> exceptions = this.restServerClient.getFailover(this.jobID, this.lastDetectTime, now);
        this.lastDetectTime = now;
        if (exceptions == null) {
            return null;
        }
        LinkedList<JobVertexID> jobVertexIDs = new LinkedList<JobVertexID>();
        block0: for (JobVertexID vertexID : exceptions.keySet()) {
            for (JobException exception : exceptions.get((Object)vertexID)) {
                if (!exception.getMessage().contains("Java heap space")) continue;
                jobVertexIDs.add(vertexID);
                continue block0;
            }
        }
        if (!jobVertexIDs.isEmpty()) {
            LOGGER.info("Heap OOM detected for vertices {}.", jobVertexIDs);
            return new JobVertexHeapOOM(this.jobID, jobVertexIDs);
        }
        return null;
    }
}

