/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggType;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.TaskMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexHighDelay;
import org.apache.flink.runtime.healthmanager.plugins.utils.HealthMonitorOptions;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighDelayDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighDelayDetector.class);
    public static final ConfigOption<Long> HIGH_DELAY_THRESHOLD = ConfigOptions.key((String)"healthmonitor.high-delay.threshold.ms").defaultValue((Object)600000L);
    public static final ConfigOption<Long> SEVERE_DELAY_THRESHOLD = ConfigOptions.key((String)"healthmonitor.severe-delay.threshold.ms").defaultValue((Object)3600000L);
    private JobID jobID;
    private HealthMonitor healthMonitor;
    private MetricProvider metricProvider;
    private long highDelayCheckInterval;
    private long highDelayThreshold;
    private long severeDelayThreshold;
    private Map<JobVertexID, TaskMetricSubscription> delaySubs;

    @Override
    public void open(HealthMonitor monitor) {
        this.healthMonitor = monitor;
        this.jobID = monitor.getJobID();
        this.metricProvider = monitor.getMetricProvider();
        this.highDelayCheckInterval = monitor.getConfig().getLong(HealthMonitorOptions.PARALLELISM_SCALE_INTERVAL);
        this.highDelayThreshold = monitor.getConfig().getLong(HIGH_DELAY_THRESHOLD);
        this.severeDelayThreshold = monitor.getConfig().getLong(SEVERE_DELAY_THRESHOLD);
        this.delaySubs = new HashMap<JobVertexID, TaskMetricSubscription>();
        for (JobVertexID vertexId : monitor.getJobConfig().getVertexConfigs().keySet()) {
            if (monitor.getJobConfig().getInputNodes().get((Object)vertexId).size() != 0) continue;
            TaskMetricSubscription delaySub = this.metricProvider.subscribeTaskMetric(this.jobID, vertexId, "fetched_delay", MetricAggType.MAX, this.highDelayCheckInterval, TimelineAggType.LATEST);
            this.delaySubs.put(vertexId, delaySub);
        }
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.delaySubs != null) {
            for (TaskMetricSubscription delaySub : this.delaySubs.values()) {
                if (delaySub == null) continue;
                this.metricProvider.unsubscribe(delaySub);
            }
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        ArrayList<JobVertexID> jobVertexIDs = new ArrayList<JobVertexID>();
        ArrayList<JobVertexID> severeJobVertexIDs = new ArrayList<JobVertexID>();
        for (JobVertexID vertexId : this.delaySubs.keySet()) {
            TaskMetricSubscription delaySub = this.delaySubs.get((Object)vertexId);
            if (!MetricUtils.validateTaskMetric(this.healthMonitor, this.highDelayCheckInterval * 2L, delaySub)) {
                LOGGER.debug("Skip vertex {}, metrics missing.", (Object)vertexId);
                continue;
            }
            if ((Double)delaySub.getValue().f1 > (double)this.highDelayThreshold) {
                jobVertexIDs.add(vertexId);
            }
            if (!((Double)delaySub.getValue().f1 > (double)this.severeDelayThreshold)) continue;
            severeJobVertexIDs.add(vertexId);
        }
        if (!jobVertexIDs.isEmpty()) {
            LOGGER.info("High delay detected for high delay vertices {} severe delay vertices {}.", jobVertexIDs, severeJobVertexIDs);
            return new JobVertexHighDelay(this.jobID, jobVertexIDs, severeJobVertexIDs);
        }
        return null;
    }
}

