/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggType;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.TaskMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexLargeTimerCount;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeTimerCountDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LargeTimerCountDetector.class);
    public static final ConfigOption<Long> LARGE_TIMER_COUNT_THRESHOLD = ConfigOptions.key((String)"healthmonitor.timer-count.threshold").defaultValue((Object)6000000L);
    private JobID jobID;
    private MetricProvider metricProvider;
    private HealthMonitor monitor;
    private final long timerCountCheckInterval = 1L;
    private long largeTimerCountThreshold;
    private Map<JobVertexID, TaskMetricSubscription> timerCountSubs;

    @Override
    public void open(HealthMonitor monitor) {
        this.jobID = monitor.getJobID();
        this.metricProvider = monitor.getMetricProvider();
        this.monitor = monitor;
        this.largeTimerCountThreshold = monitor.getConfig().getLong(LARGE_TIMER_COUNT_THRESHOLD);
        this.timerCountSubs = new HashMap<JobVertexID, TaskMetricSubscription>();
        for (JobVertexID vertexId : monitor.getJobConfig().getVertexConfigs().keySet()) {
            TaskMetricSubscription timerCountSub = this.metricProvider.subscribeTaskMetric(this.jobID, vertexId, "HeapTimerCount.Total", MetricAggType.MAX, 1L, TimelineAggType.LATEST);
            this.timerCountSubs.put(vertexId, timerCountSub);
        }
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.timerCountSubs != null) {
            for (TaskMetricSubscription timerCountSub : this.timerCountSubs.values()) {
                if (timerCountSub == null) continue;
                this.metricProvider.unsubscribe(timerCountSub);
            }
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        ArrayList<JobVertexID> jobVertexIDs = new ArrayList<JobVertexID>();
        for (JobVertexID vertexId : this.timerCountSubs.keySet()) {
            TaskMetricSubscription timerCountSub = this.timerCountSubs.get((Object)vertexId);
            if (!MetricUtils.validateTmMetric(this.monitor, 1L, timerCountSub.getValue())) {
                LOGGER.debug("Skip vertex {} metric {}, metrics missing.", (Object)vertexId, timerCountSub.getValue());
                continue;
            }
            LOGGER.debug("Vertex {} timer count {}", (Object)vertexId, timerCountSub.getValue());
            if (!((Double)timerCountSub.getValue().f1 > (double)this.largeTimerCountThreshold)) continue;
            jobVertexIDs.add(vertexId);
        }
        if (!jobVertexIDs.isEmpty()) {
            LOGGER.info("Large timer count detected for vertices {}.", jobVertexIDs);
            return new JobVertexLargeTimerCount(this.jobID, jobVertexIDs);
        }
        return null;
    }
}

