/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.metrics.JobTMMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexLowMemory;
import org.apache.flink.runtime.healthmanager.plugins.utils.HealthMonitorOptions;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowMemoryDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowMemoryDetector.class);
    public static final ConfigOption<Double> LOW_MEM_THRESHOLD = ConfigOptions.key((String)"healthmonitor.low-memory-detector.threashold").defaultValue((Object)0.5);
    private JobID jobID;
    private RestServerClient restServerClient;
    private MetricProvider metricProvider;
    private HealthMonitor monitor;
    private long checkInterval;
    private double threshold;
    private long waitTime;
    private JobTMMetricSubscription tmMemAllocatedSubscription;
    private JobTMMetricSubscription tmMemTotalUsageSubscription;
    private JobTMMetricSubscription tmMemHeapUsageSubscription;
    private JobTMMetricSubscription tmMemNonHeapUsageSubscription;
    private Map<JobVertexID, Long> lowMemSince;
    private Map<JobVertexID, Double> maxHeapUtility;
    private Map<JobVertexID, Double> maxNonHeapUtility;
    private Map<JobVertexID, Double> maxNativeUtility;
    private Map<JobVertexID, Double> maxMemUsage;

    @Override
    public void open(HealthMonitor monitor) {
        this.monitor = monitor;
        this.jobID = monitor.getJobID();
        this.restServerClient = monitor.getRestServerClient();
        this.metricProvider = monitor.getMetricProvider();
        this.checkInterval = monitor.getConfig().getLong(HealthMonitorOptions.RESOURCE_SCALE_INTERVAL);
        this.threshold = monitor.getConfig().getDouble(LOW_MEM_THRESHOLD);
        this.waitTime = monitor.getConfig().getLong(HealthMonitorOptions.RESOURCE_SCALE_DOWN_WAIT_TIME);
        this.tmMemAllocatedSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.ProcessTree.Memory.Allocated", this.checkInterval, TimelineAggType.AVG);
        this.tmMemTotalUsageSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.ProcessTree.Memory.RSS", this.checkInterval, TimelineAggType.AVG);
        this.tmMemHeapUsageSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.JVM.Memory.Heap.Committed", this.checkInterval, TimelineAggType.AVG);
        this.tmMemNonHeapUsageSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.JVM.Memory.NonHeap.Committed", this.checkInterval, TimelineAggType.AVG);
        this.lowMemSince = new HashMap<JobVertexID, Long>();
        this.maxHeapUtility = new HashMap<JobVertexID, Double>();
        this.maxNonHeapUtility = new HashMap<JobVertexID, Double>();
        this.maxNativeUtility = new HashMap<JobVertexID, Double>();
        this.maxMemUsage = new HashMap<JobVertexID, Double>();
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.tmMemAllocatedSubscription != null) {
            this.metricProvider.unsubscribe(this.tmMemAllocatedSubscription);
        }
        if (this.metricProvider != null && this.tmMemTotalUsageSubscription != null) {
            this.metricProvider.unsubscribe(this.tmMemTotalUsageSubscription);
        }
        if (this.metricProvider != null && this.tmMemHeapUsageSubscription != null) {
            this.metricProvider.unsubscribe(this.tmMemHeapUsageSubscription);
        }
        if (this.metricProvider != null && this.tmMemNonHeapUsageSubscription != null) {
            this.metricProvider.unsubscribe(this.tmMemNonHeapUsageSubscription);
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        long now = System.currentTimeMillis();
        Object tmCapacities = this.tmMemAllocatedSubscription.getValue();
        Object tmTotalUsages = this.tmMemTotalUsageSubscription.getValue();
        Object tmHeapUsages = this.tmMemHeapUsageSubscription.getValue();
        Object tmNonHeapUsages = this.tmMemNonHeapUsageSubscription.getValue();
        if (tmCapacities == null || tmCapacities.isEmpty() || tmTotalUsages == null || tmTotalUsages.isEmpty() || tmHeapUsages == null || tmHeapUsages.isEmpty() || tmNonHeapUsages == null || tmNonHeapUsages.isEmpty()) {
            return null;
        }
        this.removeOutdatedMaxUsage();
        RestServerClient.JobConfig jobConfig = this.monitor.getJobConfig();
        HashMap<JobVertexID, Double> vertexTaskMaxTotalUtility = new HashMap<JobVertexID, Double>();
        HashMap<JobVertexID, Double> vertexTaskMaxHeapUtility = new HashMap<JobVertexID, Double>();
        HashMap<JobVertexID, Double> vertexTaskMaxNonHeapUtility = new HashMap<JobVertexID, Double>();
        HashMap<JobVertexID, Double> vertexTaskMaxNativeUtility = new HashMap<JobVertexID, Double>();
        for (String tmId : tmCapacities.keySet()) {
            double nonHeapUsage;
            double heapUsage;
            if (!MetricUtils.validateTmMetric(this.monitor, this.checkInterval * 2L, (Tuple2)tmCapacities.get(tmId), (Tuple2)tmTotalUsages.get(tmId), (Tuple2)tmHeapUsages.get(tmId), (Tuple2)tmNonHeapUsages.get(tmId))) {
                LOGGER.debug("Skip tm {}, metrics missing.", (Object)tmId);
                continue;
            }
            List vertexIds = this.restServerClient.getTaskManagerTasks(tmId).stream().map(executionVertexID -> executionVertexID.getJobVertexID()).collect(Collectors.toList());
            double totalUsage = (Double)((Tuple2)tmTotalUsages.get((Object)tmId)).f1 / 1024.0 / 1024.0;
            double nativeUsage = totalUsage - (heapUsage = (Double)((Tuple2)tmHeapUsages.get((Object)tmId)).f1 / 1024.0 / 1024.0) - (nonHeapUsage = (Double)((Tuple2)tmNonHeapUsages.get((Object)tmId)).f1 / 1024.0 / 1024.0);
            if (nativeUsage < 0.0) {
                LOGGER.debug("Skip tm {}, abnormal native usage {}.", (Object)tmId, (Object)nativeUsage);
                continue;
            }
            double totalCapacity = (Double)((Tuple2)tmCapacities.get((Object)tmId)).f1 / 1024.0 / 1024.0;
            double heapCapacity = 0.0;
            double nonHeapCapacity = 0.0;
            double nativeCapacity = 0.0;
            for (JobVertexID vertexID : vertexIds) {
                ResourceSpec currentResource = jobConfig.getVertexConfigs().get((Object)vertexID).getResourceSpec();
                heapCapacity += (double)currentResource.getHeapMemory();
                nonHeapCapacity += (double)currentResource.getDirectMemory();
                nativeCapacity += (double)currentResource.getNativeMemory();
            }
            double totalUtility = totalUsage / (totalCapacity == 0.0 ? 1.0 : totalCapacity);
            double heapUtility = heapUsage / (heapCapacity == 0.0 ? 1.0 : heapCapacity);
            double nonHeapUtility = nonHeapUsage / (nonHeapCapacity == 0.0 ? 1.0 : nonHeapCapacity);
            double nativeUtility = nativeUsage / (nativeCapacity == 0.0 ? 1.0 : nativeCapacity);
            for (JobVertexID vertexID : vertexIds) {
                if (!vertexTaskMaxTotalUtility.containsKey((Object)vertexID) || (Double)vertexTaskMaxTotalUtility.get((Object)vertexID) < totalUtility) {
                    vertexTaskMaxTotalUtility.put(vertexID, totalUtility);
                }
                if (!vertexTaskMaxHeapUtility.containsKey((Object)vertexID) || (Double)vertexTaskMaxHeapUtility.get((Object)vertexID) < heapUtility) {
                    vertexTaskMaxHeapUtility.put(vertexID, heapUtility);
                }
                if (!vertexTaskMaxNonHeapUtility.containsKey((Object)vertexID) || (Double)vertexTaskMaxNonHeapUtility.get((Object)vertexID) < nonHeapUtility) {
                    vertexTaskMaxNonHeapUtility.put(vertexID, nonHeapUtility);
                }
                if (vertexTaskMaxNativeUtility.containsKey((Object)vertexID) && !((Double)vertexTaskMaxNativeUtility.get((Object)vertexID) < nativeUtility)) continue;
                vertexTaskMaxNativeUtility.put(vertexID, nativeUtility);
            }
        }
        for (JobVertexID vertexID : vertexTaskMaxTotalUtility.keySet()) {
            if ((Double)vertexTaskMaxTotalUtility.get((Object)vertexID) >= this.threshold) {
                this.lowMemSince.put(vertexID, Long.MAX_VALUE);
                this.maxMemUsage.remove((Object)vertexID);
                this.maxHeapUtility.remove((Object)vertexID);
                this.maxNonHeapUtility.remove((Object)vertexID);
                this.maxNativeUtility.remove((Object)vertexID);
            } else {
                ResourceSpec resourceSpec = jobConfig.getVertexConfigs().get((Object)vertexID).getResourceSpec();
                double usage = (Double)vertexTaskMaxHeapUtility.get((Object)vertexID) * (double)(resourceSpec.getHeapMemory() + resourceSpec.getDirectMemory() + resourceSpec.getNativeMemory());
                this.lowMemSince.put(vertexID, Math.min(now, this.lowMemSince.getOrDefault((Object)vertexID, Long.MAX_VALUE)));
                this.maxMemUsage.put(vertexID, Math.max(usage, this.maxMemUsage.getOrDefault((Object)vertexID, 0.0)));
                this.maxHeapUtility.put(vertexID, Math.max((Double)vertexTaskMaxHeapUtility.get((Object)vertexID), this.maxHeapUtility.getOrDefault((Object)vertexID, 0.0)));
                this.maxNonHeapUtility.put(vertexID, Math.max((Double)vertexTaskMaxNonHeapUtility.get((Object)vertexID), this.maxNonHeapUtility.getOrDefault((Object)vertexID, 0.0)));
                this.maxNativeUtility.put(vertexID, Math.max((Double)vertexTaskMaxNativeUtility.get((Object)vertexID), this.maxNativeUtility.getOrDefault((Object)vertexID, 0.0)));
            }
            LOGGER.debug("Vertex {}, total utility {}, lowMemSince {}, maxHeapUtility {}, maxNonHeapUtility {}, maxNativeUtility {}, maxMemUsage {}.", new Object[]{vertexID, vertexTaskMaxTotalUtility.get((Object)vertexID), this.lowMemSince.get((Object)vertexID), this.maxHeapUtility.getOrDefault((Object)vertexID, 0.0), this.maxNonHeapUtility.getOrDefault((Object)vertexID, 0.0), this.maxNativeUtility.getOrDefault((Object)vertexID, 0.0), this.maxMemUsage.getOrDefault((Object)vertexID, 0.0)});
        }
        JobVertexLowMemory jobVertexLowMemory = new JobVertexLowMemory(this.jobID);
        for (Map.Entry<JobVertexID, Long> entry : this.lowMemSince.entrySet()) {
            if (now - entry.getValue() <= this.waitTime) continue;
            JobVertexID vertexID = entry.getKey();
            jobVertexLowMemory.addVertex(vertexID, this.maxHeapUtility.get((Object)vertexID), this.maxNonHeapUtility.get((Object)vertexID), this.maxNativeUtility.get((Object)vertexID));
        }
        if (jobVertexLowMemory.isEmpty()) {
            return null;
        }
        LOGGER.info("Memory low detected: {}.", (Object)jobVertexLowMemory);
        return jobVertexLowMemory;
    }

    private void removeOutdatedMaxUsage() {
        RestServerClient.JobConfig jobConfig = this.monitor.getJobConfig();
        HashSet<JobVertexID> verticeToRemove = new HashSet<JobVertexID>();
        for (JobVertexID vertexID : this.maxMemUsage.keySet()) {
            double capacity;
            ResourceSpec resourceSpec = jobConfig.getVertexConfigs().get((Object)vertexID).getResourceSpec();
            double maxUsage = this.maxMemUsage.get((Object)vertexID);
            if (!(maxUsage / (capacity = (double)(resourceSpec.getHeapMemory() + resourceSpec.getDirectMemory() + resourceSpec.getNativeMemory())) >= this.threshold)) continue;
            verticeToRemove.add(vertexID);
            LOGGER.debug("Remove outdated max usage for vertex {}, maxUsage: {}, capacity: {}.", new Object[]{vertexID, maxUsage, capacity});
        }
        for (JobVertexID vertexID : verticeToRemove) {
            this.lowMemSince.put(vertexID, Long.MAX_VALUE);
            this.maxMemUsage.remove((Object)vertexID);
        }
    }
}

