/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.utils;

import org.apache.flink.runtime.jobgraph.JobVertexID;

public class TaskMetrics {
    private final JobVertexID jobVertexID;
    private final boolean isParallelSource;
    private final double inputTps;
    private final double outputTps;
    private final double timerCount;
    private final double taskLatencyPerRecord;
    private final double sourceLatencyPerRecord;
    private final double waitOutputPerRecord;
    private final double workload;
    private final double delayIncreasingRate;
    private final double partitionLatency;
    private final double partitionCount;
    private final double maxInputTpsPerMinute;

    public TaskMetrics(JobVertexID jobVertexId, boolean isParallelSource, double inputTps, double maxInputTpsPerMinute, double outputTps, double timerCount, double taskLatencyPerRecord, double sourceLatencyPerRecord, double waitOutputPerRecord, double workload, double delayIncreasingRate, double partitionLatency, double partitionCount) {
        this.jobVertexID = jobVertexId;
        this.maxInputTpsPerMinute = maxInputTpsPerMinute;
        this.isParallelSource = isParallelSource;
        this.inputTps = inputTps;
        this.outputTps = outputTps;
        this.timerCount = timerCount;
        this.taskLatencyPerRecord = taskLatencyPerRecord;
        this.sourceLatencyPerRecord = sourceLatencyPerRecord;
        this.waitOutputPerRecord = waitOutputPerRecord;
        this.workload = workload;
        this.delayIncreasingRate = delayIncreasingRate;
        this.partitionLatency = partitionLatency;
        this.partitionCount = partitionCount;
    }

    public TaskMetrics(JobVertexID jobVertexId, boolean isParallelSource, double inputTps, double outputTps, double timerCount, double taskLatencyPerRecord, double sourceLatencyPerRecord, double waitOutputPerRecord, double workload, double delayIncreasingRate, double partitionLatency, double partitionCount) {
        this(jobVertexId, isParallelSource, inputTps, 0.0, outputTps, timerCount, taskLatencyPerRecord, sourceLatencyPerRecord, waitOutputPerRecord, workload, delayIncreasingRate, partitionLatency, partitionCount);
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }

    public double getInputTps() {
        return this.inputTps;
    }

    public double getOutputTps() {
        return this.outputTps;
    }

    public double getTimerCount() {
        return this.timerCount;
    }

    public double getTaskLatencyPerRecord() {
        return this.taskLatencyPerRecord;
    }

    public double getSourceLatencyPerRecord() {
        return this.sourceLatencyPerRecord;
    }

    public double getWaitOutputPerRecord() {
        return this.waitOutputPerRecord;
    }

    public double getWorkload() {
        return this.workload;
    }

    public boolean isParallelSource() {
        return this.isParallelSource;
    }

    public double getPartitionLatency() {
        return this.partitionLatency;
    }

    public double getPartitionCount() {
        return this.partitionCount;
    }

    public String toString() {
        return "TaskMetrics{JobVertexID:" + (Object)((Object)this.jobVertexID) + ", isParallelSource:" + this.isParallelSource + ", inputTps:" + this.inputTps + ", maxInputTpsPerMinute:" + this.maxInputTpsPerMinute + ", outputTps:" + this.outputTps + ", timerCount:" + this.timerCount + ", taskLatencyPerRecord:" + this.taskLatencyPerRecord + ", sourceLatencyPerRecord:" + this.sourceLatencyPerRecord + ", waitOutputPerRecord:" + this.waitOutputPerRecord + ", workload:" + this.workload + ", delayIncreasingRate:" + this.delayIncreasingRate + ", partitionLatency:" + this.partitionLatency + ", partitionCount:" + this.partitionCount + "}";
    }

    public double getDelayIncreasingRate() {
        return this.delayIncreasingRate;
    }

    public double getMaxInputTpsPerMinute() {
        return this.maxInputTpsPerMinute;
    }
}

