/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.filesystem;

import java.io.IOException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.RunningJobsRegistry;
import org.apache.flink.runtime.highavailability.nonha.standalone.StandaloneRunningJobsRegistry;
import org.apache.flink.runtime.jobmanager.FileSystemSubmittedJobGraphStore;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.runtime.leaderelection.LeaderElectionService;
import org.apache.flink.runtime.leaderelection.StandaloneLeaderElectionService;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;

public class FileSystemHaServices
implements HighAvailabilityServices {
    private final String resourceManagerAddress;
    private final String dispatcherAddress;
    private final String jobManagerAddress;
    private final String webMonitorAddress;
    private final String jobGraphPath;
    protected final Object lock = new Object();
    private final RunningJobsRegistry runningJobsRegistry;
    private final BlobStoreService blobStoreService;
    private boolean shutdown;

    public FileSystemHaServices(String resourceManagerAddress, String dispatcherAddress, String jobManagerAddress, String webMonitorAddress, String jobGraphPath, BlobStoreService blobStoreService) {
        this.resourceManagerAddress = (String)Preconditions.checkNotNull((Object)resourceManagerAddress, (String)"resourceManagerAddress");
        this.dispatcherAddress = (String)Preconditions.checkNotNull((Object)dispatcherAddress, (String)"dispatcherAddress");
        this.jobManagerAddress = (String)Preconditions.checkNotNull((Object)jobManagerAddress, (String)"jobManagerAddress");
        this.webMonitorAddress = (String)Preconditions.checkNotNull((Object)webMonitorAddress, (String)webMonitorAddress);
        this.jobGraphPath = (String)Preconditions.checkNotNull((Object)jobGraphPath, (String)"jobGraphPath");
        this.blobStoreService = (BlobStoreService)Preconditions.checkNotNull((Object)blobStoreService, (String)"blobStoreService");
        this.runningJobsRegistry = new StandaloneRunningJobsRegistry();
        this.shutdown = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.resourceManagerAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.dispatcherAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getResourceManagerLeaderElectionService() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElectionService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getDispatcherLeaderElectionService() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElectionService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.jobManagerAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(defaultJobManagerAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getJobManagerLeaderElectionService(JobID jobID) {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElectionService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getWebMonitorLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderRetrievalService(this.webMonitorAddress, DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElectionService getWebMonitorLeaderElectionService() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneLeaderElectionService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckpointRecoveryFactory getCheckpointRecoveryFactory() {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new StandaloneCheckpointRecoveryFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubmittedJobGraphStore getSubmittedJobGraphStore() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return new FileSystemSubmittedJobGraphStore(this.jobGraphPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunningJobsRegistry getRunningJobsRegistry() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return this.runningJobsRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobStore createBlobStore() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            return this.blobStoreService;
        }
    }

    @Override
    public void close() throws Exception {
        Throwable exception = null;
        try {
            this.blobStoreService.close();
        }
        catch (Throwable t) {
            exception = t;
        }
        this.internalClose();
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)"Could not properly close the FileSystemHaServices.");
        }
    }

    @Override
    public void closeAndCleanupAllData() throws Exception {
        Throwable exception = null;
        try {
            this.blobStoreService.closeAndCleanupAllData();
        }
        catch (Throwable t) {
            exception = t;
        }
        this.internalClose();
        if (exception != null) {
            ExceptionUtils.rethrowException((Throwable)exception, (String)"Could not properly close and clean up all data of FileSystemHaServices.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalClose() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.shutdown) {
                this.shutdown = true;
            }
        }
    }

    @GuardedBy(value="lock")
    private void checkNotShutdown() {
        Preconditions.checkState((!this.shutdown ? 1 : 0) != 0, (Object)"high availability services are shut down");
    }
}

