/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.StreamFileChannelReader;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.NioBufferedFileInputStream;

final class StreamReadRequest
implements ReadRequest {
    private final AsynchronousFileIOChannel<Buffer, ReadRequest> channel;
    private final Buffer buffer;
    private final AtomicBoolean hasReachedEndOfFile;
    private final long startPosition;
    private final long bytesToRead;
    private final int bufferSize;

    protected StreamReadRequest(AsynchronousFileIOChannel<Buffer, ReadRequest> targetChannel, Buffer buffer, AtomicBoolean hasReachedEndOfFile, long startPosition, long bytesToRead, int bufferSize) {
        this.channel = targetChannel;
        this.buffer = buffer;
        this.hasReachedEndOfFile = hasReachedEndOfFile;
        this.startPosition = startPosition;
        this.bytesToRead = bytesToRead;
        this.bufferSize = bufferSize;
    }

    @Override
    public void read() throws IOException {
        if (!this.hasReachedEndOfFile.get()) {
            if (this.bufferSize == -1) {
                this.hasReachedEndOfFile.set(StreamFileChannelReader.readBufferFromFileChannel(this.channel.fileChannel, this.buffer, this.startPosition, this.bytesToRead, this.channel.id.getPathFile()));
            } else {
                NioBufferedFileInputStream in = this.channel.getBufferedInputStream(this.bufferSize);
                if (in.available() > 0) {
                    this.hasReachedEndOfFile.set(StreamFileChannelReader.readBufferFromFileBufferedChannel(in, this.buffer, this.startPosition, this.bytesToRead, this.channel.id.getPathFile()));
                } else {
                    this.hasReachedEndOfFile.set(true);
                }
            }
        }
    }

    @Override
    public void requestDone(IOException error) {
        this.channel.handleProcessedBuffer(this.buffer, error);
    }
}

