/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.Closeable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class BufferConsumer
implements Closeable {
    private final Buffer buffer;
    private final CachedPositionMarker writerPosition;
    private int currentReaderPosition = 0;

    public BufferConsumer(MemorySegment memorySegment, BufferRecycler recycler, BufferBuilder.PositionMarker currentWriterPosition) {
        this(new NetworkBuffer((MemorySegment)Preconditions.checkNotNull((Object)memorySegment), (BufferRecycler)Preconditions.checkNotNull((Object)recycler), true), currentWriterPosition, 0);
    }

    public BufferConsumer(MemorySegment memorySegment, BufferRecycler recycler, boolean isBuffer) {
        this(new NetworkBuffer((MemorySegment)Preconditions.checkNotNull((Object)memorySegment), (BufferRecycler)Preconditions.checkNotNull((Object)recycler), isBuffer), () -> -memorySegment.size(), 0);
        Preconditions.checkState((memorySegment.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isFinished(), (Object)"BufferConsumer with static size must be finished after construction!");
    }

    private BufferConsumer(Buffer buffer, BufferBuilder.PositionMarker currentWriterPosition, int currentReaderPosition) {
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
        this.writerPosition = new CachedPositionMarker((BufferBuilder.PositionMarker)Preconditions.checkNotNull((Object)currentWriterPosition));
        this.currentReaderPosition = currentReaderPosition;
    }

    public boolean isFinished() {
        return this.writerPosition.isFinished();
    }

    public Buffer build() {
        this.writerPosition.update();
        Buffer slice = this.buffer.readOnlySlice(this.currentReaderPosition, this.writerPosition.getCached() - this.currentReaderPosition);
        this.currentReaderPosition = this.writerPosition.getCached();
        return slice.retainBuffer();
    }

    public BufferConsumer copy() {
        return new BufferConsumer(this.buffer.retainBuffer(), this.writerPosition.positionMarker, this.currentReaderPosition);
    }

    public boolean isBuffer() {
        return this.buffer.isBuffer();
    }

    @Override
    public void close() {
        if (!this.buffer.isRecycled()) {
            this.buffer.recycleBuffer();
        }
    }

    public boolean isRecycled() {
        return this.buffer.isRecycled();
    }

    public int getWrittenBytes() {
        return this.writerPosition.getCached();
    }

    public boolean isDataAvailable() {
        return this.currentReaderPosition < this.writerPosition.getLatest();
    }

    private static class CachedPositionMarker {
        private final BufferBuilder.PositionMarker positionMarker;
        private int cachedPosition;

        public CachedPositionMarker(BufferBuilder.PositionMarker positionMarker) {
            this.positionMarker = (BufferBuilder.PositionMarker)Preconditions.checkNotNull((Object)positionMarker);
            this.update();
        }

        public boolean isFinished() {
            return BufferBuilder.PositionMarker.isFinished(this.cachedPosition);
        }

        public int getCached() {
            return BufferBuilder.PositionMarker.getAbsolute(this.cachedPosition);
        }

        private int getLatest() {
            return BufferBuilder.PositionMarker.getAbsolute(this.positionMarker.get());
        }

        private void update() {
            this.cachedPosition = this.positionMarker.get();
        }
    }
}

