/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.util.Preconditions;

public class NettyUtils {
    private static final Set<String> NETWORK_ERROR_MESSAGES = new HashSet<String>(){
        {
            this.add("Connection reset by peer");
            this.add("Broken pipe");
        }
    };

    public static boolean isNetworkError(Throwable cause) {
        Preconditions.checkNotNull((Object)cause);
        return cause instanceof IOException && cause.getMessage() != null && NETWORK_ERROR_MESSAGES.contains(cause.getMessage());
    }
}

