/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;

class SequenceNumberingViewReader
implements BufferAvailabilityListener,
NetworkSequenceViewReader {
    private final Object requestLock = new Object();
    private final InputChannelID receiverId;
    private final PartitionRequestQueue requestQueue;
    private volatile ResultSubpartitionView subpartitionView;
    private int sequenceNumber = -1;
    private boolean isRegisteredAvailable;

    SequenceNumberingViewReader(InputChannelID receiverId, PartitionRequestQueue requestQueue) {
        this.receiverId = receiverId;
        this.requestQueue = requestQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSubpartitionView(ResultPartitionProvider partitionProvider, ResultPartitionID resultPartitionId, int subPartitionIndex) throws IOException {
        Object object = this.requestLock;
        synchronized (object) {
            if (this.subpartitionView != null) {
                throw new IllegalStateException("Subpartition already requested");
            }
            this.subpartitionView = partitionProvider.createSubpartitionView(resultPartitionId, subPartitionIndex, this);
        }
    }

    @Override
    public void addCredit(int creditDeltas) {
    }

    @Override
    public void setRegisteredAsAvailable(boolean isRegisteredAvailable) {
        this.isRegisteredAvailable = isRegisteredAvailable;
    }

    @Override
    public boolean isRegisteredAsAvailable() {
        return this.isRegisteredAvailable;
    }

    @Override
    public boolean isAvailable() {
        return this.subpartitionView.isAvailable();
    }

    @Override
    public InputChannelID getReceiverId() {
        return this.receiverId;
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public InputChannel.BufferAndAvailability getNextBuffer() throws IOException, InterruptedException {
        ResultSubpartition.BufferAndBacklog next = this.subpartitionView.getNextBuffer();
        if (next != null) {
            ++this.sequenceNumber;
            return new InputChannel.BufferAndAvailability(next.buffer(), next.isMoreAvailable(), next.buffersInBacklog());
        }
        return null;
    }

    @Override
    public boolean isReleased() {
        return this.subpartitionView.isReleased();
    }

    @Override
    public Throwable getFailureCause() {
        return this.subpartitionView.getFailureCause();
    }

    @Override
    public void releaseAllResources(@Nullable Throwable throwable) throws IOException {
        this.subpartitionView.releaseAllResources(throwable);
    }

    @Override
    public void notifyDataAvailable() {
        this.requestQueue.notifyReaderNonEmpty(this);
    }

    public String toString() {
        return "SequenceNumberingViewReader{requestLock=" + this.requestLock + ", receiverId=" + (Object)((Object)this.receiverId) + ", sequenceNumber=" + this.sequenceNumber + ", isRegisteredAsAvailable=" + this.isRegisteredAvailable + '}';
    }
}

