/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.slf4j.Logger;

public enum BlockingShuffleType {
    TM,
    YARN;


    public static BlockingShuffleType getBlockingShuffleTypeFromConfiguration(Configuration configuration, Logger logger) {
        BlockingShuffleType shuffleType;
        block2: {
            try {
                shuffleType = BlockingShuffleType.valueOf(configuration.getString(TaskManagerOptions.TASK_BLOCKING_SHUFFLE_TYPE).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                shuffleType = BlockingShuffleType.valueOf((String)TaskManagerOptions.TASK_BLOCKING_SHUFFLE_TYPE.defaultValue());
                if (logger == null) break block2;
                logger.warn("The configured blocking shuffle type [" + configuration.getString(TaskManagerOptions.TASK_BLOCKING_SHUFFLE_TYPE) + "] is illegal, using default value: " + (Object)((Object)shuffleType), (Throwable)e);
            }
        }
        return shuffleType;
    }
}

