/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ConsumptionDeclinedException;
import org.apache.flink.runtime.io.network.partition.InternalResultPartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ReconnectableSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrainablePipelinedSubpartition
extends PipelinedSubpartition
implements ReconnectableSubpartition {
    private static final Logger LOG = LoggerFactory.getLogger(DrainablePipelinedSubpartition.class);
    private BufferConsumer unfinishedBuffer;
    private ReconnectableSubpartition.State state = ReconnectableSubpartition.State.INITIALIZED;

    DrainablePipelinedSubpartition(int index, InternalResultPartition parent) {
        super(index, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(BufferConsumer bufferConsumer) throws IOException {
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.state != ReconnectableSubpartition.State.SUSPENDED) {
                return super.add(bufferConsumer);
            }
            this.clearFinishedBuffer();
            if (this.unfinishedBuffer != null) {
                this.unfinishedBuffer.build().recycleBuffer();
                Preconditions.checkState((boolean)this.unfinishedBuffer.isFinished());
                this.unfinishedBuffer.close();
                this.unfinishedBuffer = null;
            }
            bufferConsumer.build().recycleBuffer();
            if (bufferConsumer.isFinished()) {
                bufferConsumer.close();
            } else {
                this.unfinishedBuffer = bufferConsumer;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.state != ReconnectableSubpartition.State.SUSPENDED) {
                super.flush();
            } else if (this.unfinishedBuffer != null) {
                this.unfinishedBuffer.build().recycleBuffer();
                if (this.unfinishedBuffer.isFinished()) {
                    this.unfinishedBuffer.close();
                    this.unfinishedBuffer = null;
                }
            }
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.state == ReconnectableSubpartition.State.SUSPENDED) {
            LOG.info("Draining subpartition {} is finished", (Object)super.toString());
        }
        super.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipelinedSubpartitionView createReadView(BufferAvailabilityListener availabilityListener) throws IOException {
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            Preconditions.checkState((!this.isReleased() ? 1 : 0) != 0);
            LOG.debug("Creating read view for subpartition {} of partition {}.", (Object)this.index, (Object)this.parent.getPartitionId());
            return new PipelinedSubpartitionView(this, availabilityListener, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend(@Nullable ResultSubpartitionView view) {
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.state != ReconnectableSubpartition.State.SUSPENDED) {
                if (this.readView != null) {
                    if (view == null || this.readView.equals(view)) {
                        LOG.info("{} is suspended, start draining now", (Object)this);
                        this.state = ReconnectableSubpartition.State.SUSPENDED;
                        this.clearFinishedBuffer();
                        this.readView.releaseAllResources(new ConsumptionDeclinedException(this.parent.getPartitionId()));
                        this.readView.notifyDataAvailable();
                        this.readView = null;
                    } else {
                        LOG.info("Suspending is ignored because {} does not match the attached {}", (Object)view, (Object)this.readView);
                    }
                } else {
                    LOG.info("{} is suspended, start draining now", (Object)this);
                    this.state = ReconnectableSubpartition.State.SUSPENDED;
                    this.clearFinishedBuffer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allowConsuming(ResultSubpartitionView view) {
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.state != ReconnectableSubpartition.State.INITIALIZED) {
                LOG.info("{} is allowed to be consumed", (Object)this);
                this.clearFinishedBuffer();
                Preconditions.checkState((boolean)this.buffers.isEmpty(), (Object)"Buffer should be empty after draining");
                if (this.unfinishedBuffer != null) {
                    this.unfinishedBuffer.build().recycleBuffer();
                    Preconditions.checkState((boolean)this.unfinishedBuffer.isFinished(), (Object)"Buffer should be finished after draining");
                    this.unfinishedBuffer.close();
                    this.unfinishedBuffer = null;
                }
            }
            if (this.state == ReconnectableSubpartition.State.CONSUMING) {
                Preconditions.checkState((this.readView != null ? 1 : 0) != 0, (Object)"There should be a view attached in consuming state");
                LOG.warn("There is still a view {} attached, fail it", (Object)this.readView);
                this.readView.releaseAllResources(new ConsumptionDeclinedException(this.parent.getPartitionId()));
                this.readView.notifyDataAvailable();
            }
            this.readView = (PipelinedSubpartitionView)view;
            this.readView.allowConsuming();
            this.state = ReconnectableSubpartition.State.CONSUMING;
            this.updateFlushRequestedFlag(false);
            if (!this.buffers.isEmpty()) {
                this.readView.notifyDataAvailable();
            }
        }
    }

    @Override
    public ReconnectableSubpartition.State getState() {
        return this.state;
    }

    @Override
    public String toString() {
        return String.format("Drainable [ with state %s ] %s ", this.state.toString(), super.toString());
    }

    @VisibleForTesting
    BufferConsumer getUnfinishedBuffer() {
        return this.unfinishedBuffer;
    }

    private int clearFinishedBuffer() {
        int drainedBufferCount = 0;
        Iterator it = this.buffers.iterator();
        while (it.hasNext()) {
            BufferConsumer buffer = (BufferConsumer)it.next();
            buffer.build().recycleBuffer();
            if (!buffer.isFinished()) continue;
            buffer.close();
            it.remove();
            ++drainedBufferCount;
        }
        return drainedBufferCount;
    }
}

