/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.buffer.BufferProvider;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ConsumptionDeclinedException;
import org.apache.flink.runtime.io.network.partition.DrainablePipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ReconnectableSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SpillableSubpartition;
import org.apache.flink.runtime.metrics.SumAndCount;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalResultPartition<T>
extends ResultPartition<T>
implements BufferPoolOwner {
    private static final Logger LOG = LoggerFactory.getLogger(InternalResultPartition.class);
    private final TaskActions taskActions;
    private final RecordSerializer serializer;
    private final Optional<BufferBuilder>[] bufferBuilders;
    private final ResultSubpartition[] subpartitions;
    private final ArrayDeque<ConsumerEvent>[] consumerEvents;
    private final AtomicBoolean[] consumerEventTriggered;
    private final ResultPartitionManager partitionManager;
    private final ResultPartitionConsumableNotifier partitionConsumableNotifier;
    private final boolean sendScheduleOrUpdateConsumersMessage;
    private final AtomicInteger pendingReferences = new AtomicInteger();
    private BufferPool bufferPool;
    private boolean hasNotifiedPipelinedConsumers;
    private boolean enableTracingMetrics;
    private int tracingMetricsInterval;
    private long resultCounter = 0L;
    private SumAndCount nsWaitBufferTime;
    private boolean traceTriggered = false;
    private long waitOutputForCurrentRecord = 0L;
    private Counter numRecordsSent;
    private ConsumerFailureBehavior consumerFailureBehavior;

    public InternalResultPartition(String owningTaskName, TaskActions taskActions, JobID jobId, ResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, ResultPartitionConsumableNotifier partitionConsumableNotifier, IOManager ioManager, boolean sendScheduleOrUpdateConsumersMessage) {
        this(owningTaskName, taskActions, jobId, partitionId, partitionType, numberOfSubpartitions, numTargetKeyGroups, partitionManager, partitionConsumableNotifier, ioManager, sendScheduleOrUpdateConsumersMessage, ConsumerFailureBehavior.NOTHING);
    }

    public InternalResultPartition(String owningTaskName, TaskActions taskActions, JobID jobId, ResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions, int numTargetKeyGroups, ResultPartitionManager partitionManager, ResultPartitionConsumableNotifier partitionConsumableNotifier, IOManager ioManager, boolean sendScheduleOrUpdateConsumersMessage, ConsumerFailureBehavior consumerFailureBehavior) {
        super(owningTaskName, jobId, partitionId, partitionType, numberOfSubpartitions, numTargetKeyGroups);
        int i;
        this.taskActions = (TaskActions)Preconditions.checkNotNull((Object)taskActions);
        this.subpartitions = new ResultSubpartition[numberOfSubpartitions];
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.partitionConsumableNotifier = (ResultPartitionConsumableNotifier)Preconditions.checkNotNull((Object)partitionConsumableNotifier);
        this.sendScheduleOrUpdateConsumersMessage = sendScheduleOrUpdateConsumersMessage;
        this.serializer = new SpanningRecordSerializer();
        this.consumerFailureBehavior = consumerFailureBehavior;
        this.bufferBuilders = new Optional[numberOfSubpartitions];
        for (i = 0; i < numberOfSubpartitions; ++i) {
            this.bufferBuilders[i] = Optional.empty();
        }
        this.consumerEvents = new ArrayDeque[numberOfSubpartitions];
        this.consumerEventTriggered = new AtomicBoolean[numberOfSubpartitions];
        for (i = 0; i < numberOfSubpartitions; ++i) {
            this.consumerEvents[i] = new ArrayDeque();
            this.consumerEventTriggered[i] = new AtomicBoolean(false);
        }
        switch (partitionType) {
            case BLOCKING: {
                for (i = 0; i < this.subpartitions.length; ++i) {
                    this.subpartitions[i] = new SpillableSubpartition(i, this, ioManager, true);
                }
                break;
            }
            case PIPELINED: {
                for (i = 0; i < this.subpartitions.length; ++i) {
                    this.subpartitions[i] = consumerFailureBehavior == ConsumerFailureBehavior.DRAIN ? new DrainablePipelinedSubpartition(i, this) : new PipelinedSubpartition(i, this);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported result partition type.");
            }
        }
        this.pin();
        LOG.debug("{}: Initialized {}", (Object)owningTaskName, (Object)this);
    }

    public void registerBufferPool(BufferPool bufferPool) {
        Preconditions.checkArgument((bufferPool.getNumberOfRequiredMemorySegments() >= this.getNumberOfSubpartitions() ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Buffer pool has not enough guaranteed buffers for this result partition.");
        Preconditions.checkState((this.bufferPool == null ? 1 : 0) != 0, (Object)"Bug in result partition setup logic: Already registered buffer pool.");
        this.bufferPool = (BufferPool)Preconditions.checkNotNull((Object)bufferPool);
        if (!this.partitionType.hasBackPressure() || this.consumerFailureBehavior == ConsumerFailureBehavior.DRAIN) {
            bufferPool.setBufferPoolOwner(this);
        }
    }

    @VisibleForTesting
    public BufferProvider getBufferProvider() {
        return this.bufferPool;
    }

    public BufferPool getBufferPool() {
        return this.bufferPool;
    }

    public int getNumberOfQueuedBuffers() {
        int totalBuffers = 0;
        for (ResultSubpartition subpartition : this.subpartitions) {
            totalBuffers += subpartition.unsynchronizedGetNumberOfQueuedBuffers();
        }
        return totalBuffers;
    }

    public boolean getHasNotifiedPipelinedConsumers() {
        return this.hasNotifiedPipelinedConsumers;
    }

    @Override
    public void emitRecord(T record, int[] targetChannels, boolean isBroadcast, boolean flushAlways) throws IOException, InterruptedException {
        this.serializationDelegate.setInstance(record);
        this.serializer.serializeRecord(this.serializationDelegate);
        this.beginTracing();
        boolean pruneAfterCopying = false;
        if (isBroadcast) {
            pruneAfterCopying = this.copyFromSerializerToTargetChannel(0, true, flushAlways);
        } else {
            for (int channel : targetChannels) {
                if (!this.copyFromSerializerToTargetChannel(channel, false, flushAlways)) continue;
                pruneAfterCopying = true;
            }
        }
        if (pruneAfterCopying) {
            this.serializer.prune();
        }
        if (isBroadcast) {
            this.endTracing(this.subpartitions.length);
        } else {
            this.endTracing(targetChannels.length);
        }
    }

    @Override
    public void emitRecord(T record, int targetChannel, boolean isBroadcast, boolean flushAlways) throws IOException, InterruptedException {
        this.serializationDelegate.setInstance(record);
        this.serializer.serializeRecord(this.serializationDelegate);
        this.beginTracing();
        if (isBroadcast) {
            this.tryFinishCurrentBufferBuilder(targetChannel, true);
        }
        if (this.copyFromSerializerToTargetChannel(targetChannel, isBroadcast, flushAlways)) {
            this.serializer.prune();
        }
        if (isBroadcast) {
            this.tryFinishCurrentBufferBuilder(targetChannel, true);
        }
        if (isBroadcast) {
            this.endTracing(this.subpartitions.length);
        } else {
            this.endTracing(1L);
        }
    }

    @Override
    public void broadcastEvent(AbstractEvent event, boolean flushAlways) throws IOException {
        try (BufferConsumer eventBufferConsumer = EventSerializer.toBufferConsumer(event);){
            for (int targetChannel = 0; targetChannel < this.numberOfSubpartitions; ++targetChannel) {
                this.tryFinishCurrentBufferBuilder(targetChannel, false);
                this.processConsumerEvents(targetChannel, false);
                this.addBufferConsumer(eventBufferConsumer.copy(), targetChannel);
            }
            if (flushAlways) {
                this.flushAll();
            }
        }
    }

    @VisibleForTesting
    public void addBufferConsumer(BufferConsumer bufferConsumer, int subpartitionIndex) throws IOException {
        ResultSubpartition subpartition;
        Preconditions.checkNotNull((Object)bufferConsumer);
        try {
            this.checkInProduceState();
            subpartition = this.subpartitions[subpartitionIndex];
        }
        catch (Exception ex) {
            bufferConsumer.close();
            throw ex;
        }
        if (subpartition.add(bufferConsumer)) {
            this.notifyPipelinedConsumers();
        }
    }

    @Override
    public void flushAll() {
        for (int i = 0; i < this.subpartitions.length; ++i) {
            this.flush(i);
        }
    }

    @Override
    public void flush(int subpartitionIndex) {
        this.subpartitions[subpartitionIndex].flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish() throws IOException {
        boolean success = false;
        try {
            this.checkInProduceState();
            for (ResultSubpartition subpartition : this.subpartitions) {
                subpartition.finish();
            }
            success = true;
        }
        finally {
            if (success) {
                this.isFinished = true;
                this.notifyPipelinedConsumers();
            }
        }
    }

    public void destroyBufferPool() {
        if (this.bufferPool != null) {
            this.bufferPool.lazyDestroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSubpartitionView createSubpartitionView(int index, BufferAvailabilityListener availabilityListener) throws IOException {
        Preconditions.checkState((!this.isReleased.get() ? 1 : 0) != 0, (Object)"The result partition has been released");
        if (this.partitionType == ResultPartitionType.PIPELINED) {
            int refCnt = this.pendingReferences.get();
            Preconditions.checkState((refCnt > 0 ? 1 : 0) != 0, (Object)"Partition not pinned.");
        }
        Preconditions.checkElementIndex((int)index, (int)this.subpartitions.length, (String)"Subpartition not found.");
        ResultSubpartitionView readView = this.subpartitions[index].createReadView(availabilityListener);
        if (this.consumerFailureBehavior != ConsumerFailureBehavior.NOTHING) {
            ArrayDeque<ConsumerEvent> arrayDeque = this.consumerEvents[index];
            synchronized (arrayDeque) {
                this.consumerEvents[index].add(new ConsumerEvent(ConsumerEventType.CONNECTED, readView));
                this.consumerEventTriggered[index].set(true);
            }
        }
        LOG.debug("Created {}", (Object)readView);
        return readView;
    }

    @Override
    protected void releaseInternal() {
        for (ResultSubpartition subpartition : this.subpartitions) {
            try {
                subpartition.release();
            }
            catch (Throwable t) {
                LOG.error("Error during release of result subpartition: " + t.getMessage(), t);
            }
        }
        if (this.partitionType == ResultPartitionType.BLOCKING && this.bufferPool != null) {
            this.bufferPool.notifyBufferPoolOwnerReleased();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseMemory(int toRelease) throws IOException {
        Preconditions.checkArgument((toRelease > 0 ? 1 : 0) != 0);
        if (this.partitionType == ResultPartitionType.PIPELINED && this.consumerFailureBehavior == ConsumerFailureBehavior.NOTHING) {
            return;
        }
        for (int i = 0; i < this.subpartitions.length; ++i) {
            ResultSubpartition subpartition = this.subpartitions[i];
            if (this.consumerFailureBehavior == ConsumerFailureBehavior.DRAIN) {
                if (this.consumerEventTriggered[i].get()) {
                    ReconnectableSubpartition reconnectableSubpartition = (ReconnectableSubpartition)((Object)subpartition);
                    ArrayDeque<ConsumerEvent> arrayDeque = this.consumerEvents[i];
                    synchronized (arrayDeque) {
                        ConsumerEvent event = this.consumerEvents[i].peek();
                        Preconditions.checkNotNull((Object)event);
                        if (event.getType() == ConsumerEventType.DISCONNECTED) {
                            this.consumerEvents[i].poll();
                            reconnectableSubpartition.suspend(event.getView());
                        } else if (reconnectableSubpartition.getState() == ReconnectableSubpartition.State.INITIALIZED) {
                            this.consumerEvents[i].poll();
                            reconnectableSubpartition.allowConsuming(event.getView());
                        } else if (reconnectableSubpartition.getState() == ReconnectableSubpartition.State.CONSUMING) {
                            reconnectableSubpartition.suspend(null);
                        }
                        if (this.consumerEvents[i].isEmpty()) {
                            this.consumerEventTriggered[i].set(false);
                        }
                    }
                }
            } else {
                toRelease -= subpartition.releaseMemory();
            }
            if (toRelease <= 0) break;
        }
    }

    public String toString() {
        return "InternalResultPartition " + this.partitionId.toString() + " [" + (Object)((Object)this.partitionType) + ", " + this.subpartitions.length + " subpartitions, " + this.pendingReferences + " pending references]";
    }

    void pin() {
        block2: {
            if (this.partitionType == ResultPartitionType.PIPELINED) {
                int refCnt;
                while ((refCnt = this.pendingReferences.get()) >= 0) {
                    if (!this.pendingReferences.compareAndSet(refCnt, refCnt + this.subpartitions.length)) continue;
                    break block2;
                }
                throw new IllegalStateException("Released.");
            }
        }
    }

    void onConsumedSubpartition(int subpartitionIndex) {
        if (this.isReleased.get()) {
            return;
        }
        if (this.partitionType == ResultPartitionType.PIPELINED) {
            int refCnt = this.pendingReferences.decrementAndGet();
            if (refCnt == 0) {
                this.partitionManager.onConsumedPartition(this);
            } else if (refCnt < 0) {
                throw new IllegalStateException("All references released.");
            }
            LOG.debug("{}: Received release notification for subpartition {} (reference count now at: {}).", new Object[]{this, subpartitionIndex, this.pendingReferences});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSubpartitionConsumingFailure(int subpartitionIndex, ResultSubpartitionView view, Throwable throwable) {
        if (this.consumerFailureBehavior == ConsumerFailureBehavior.NOTHING) {
            return;
        }
        if (throwable instanceof ConsumptionDeclinedException) {
            return;
        }
        LOG.warn("Consumer of subpartition {} failed, {}", (Object)subpartitionIndex, (Object)throwable);
        ArrayDeque<ConsumerEvent> arrayDeque = this.consumerEvents[subpartitionIndex];
        synchronized (arrayDeque) {
            this.consumerEvents[subpartitionIndex].add(new ConsumerEvent(ConsumerEventType.DISCONNECTED, view));
            this.consumerEventTriggered[subpartitionIndex].set(true);
        }
    }

    ResultSubpartition[] getAllPartitions() {
        return this.subpartitions;
    }

    private void notifyPipelinedConsumers() {
        if (this.sendScheduleOrUpdateConsumersMessage && !this.hasNotifiedPipelinedConsumers && this.partitionType.isPipelined()) {
            this.partitionConsumableNotifier.notifyPartitionConsumable(this.jobId, this.partitionId, this.taskActions);
            this.hasNotifiedPipelinedConsumers = true;
        }
    }

    @Nonnull
    private BufferBuilder requestNewBufferBuilder(int targetChannel, boolean isBroadcast) throws IOException, InterruptedException {
        BufferBuilder bufferBuilder;
        Preconditions.checkState((!this.bufferBuilders[targetChannel].isPresent() || this.bufferBuilders[targetChannel].get().isFinished() ? 1 : 0) != 0);
        if (this.traceTriggered) {
            long start2 = System.nanoTime();
            bufferBuilder = this.getBufferProvider().requestBufferBuilderBlocking();
            this.waitOutputForCurrentRecord += System.nanoTime() - start2;
        } else {
            bufferBuilder = this.getBufferProvider().requestBufferBuilderBlocking();
        }
        if (isBroadcast) {
            BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
            this.addBufferConsumer(bufferConsumer, 0);
            this.bufferBuilders[0] = Optional.of(bufferBuilder);
            for (int channel = 1; channel < this.numberOfSubpartitions; ++channel) {
                Preconditions.checkState((!this.bufferBuilders[channel].isPresent() || this.bufferBuilders[channel].get().isFinished() ? 1 : 0) != 0);
                this.addBufferConsumer(bufferConsumer.copy(), channel);
                this.bufferBuilders[channel] = Optional.of(bufferBuilder);
            }
        } else {
            this.addBufferConsumer(bufferBuilder.createBufferConsumer(), targetChannel);
            this.bufferBuilders[targetChannel] = Optional.of(bufferBuilder);
        }
        return bufferBuilder;
    }

    @Nonnull
    private BufferBuilder getBufferBuilder(int targetChannel, boolean isBroadcast) throws IOException, InterruptedException {
        this.processConsumerEvents(targetChannel, isBroadcast);
        if (this.bufferBuilders[targetChannel].isPresent() && !this.bufferBuilders[targetChannel].get().isFinished()) {
            return this.bufferBuilders[targetChannel].get();
        }
        return this.requestNewBufferBuilder(targetChannel, isBroadcast);
    }

    private void processConsumerEvents(int targetChannel, boolean isBroadcast) {
        if (this.consumerFailureBehavior == ConsumerFailureBehavior.NOTHING) {
            return;
        }
        if (isBroadcast) {
            for (int i = 0; i < this.subpartitions.length; ++i) {
                this.processSubpartitionConsumerEvents(i, true);
            }
        } else {
            this.processSubpartitionConsumerEvents(targetChannel, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSubpartitionConsumerEvents(int targetChannel, boolean isBroadcast) {
        if (!this.consumerEventTriggered[targetChannel].get()) {
            return;
        }
        ArrayDeque<ConsumerEvent> arrayDeque = this.consumerEvents[targetChannel];
        synchronized (arrayDeque) {
            ConsumerEvent event;
            block7: while ((event = this.consumerEvents[targetChannel].poll()) != null) {
                switch (event.getType()) {
                    case DISCONNECTED: {
                        ((ReconnectableSubpartition)((Object)this.subpartitions[targetChannel])).suspend(event.getView());
                        continue block7;
                    }
                    case CONNECTED: {
                        if (((ReconnectableSubpartition)((Object)this.subpartitions[targetChannel])).getState() != ReconnectableSubpartition.State.INITIALIZED) {
                            this.tryFinishCurrentBufferBuilder(targetChannel, isBroadcast);
                        }
                        ((ReconnectableSubpartition)((Object)this.subpartitions[targetChannel])).allowConsuming(event.getView());
                        continue block7;
                    }
                }
                throw new IllegalStateException("Unknown consumer type " + event);
            }
            this.consumerEventTriggered[targetChannel].set(false);
        }
    }

    private void tryFinishCurrentBufferBuilder(int targetChannel, boolean isBroadcast) {
        Optional<BufferBuilder> bufferBuilder = this.bufferBuilders[targetChannel];
        if (bufferBuilder.isPresent() && !bufferBuilder.get().isFinished()) {
            this.updateMetrics(bufferBuilder.get(), isBroadcast);
        }
    }

    private void updateMetrics(BufferBuilder bufferBuilder, boolean isBroadcast) {
        if (isBroadcast) {
            this.numBytesOut.inc((long)bufferBuilder.finish() * (long)this.numberOfSubpartitions);
            this.numBuffersOut.inc((long)this.numberOfSubpartitions);
        } else {
            this.numBytesOut.inc((long)bufferBuilder.finish());
            this.numBuffersOut.inc();
        }
    }

    private boolean copyFromSerializerToTargetChannel(int targetChannel, boolean isBroadcast, boolean flushAlways) throws IOException, InterruptedException {
        this.serializer.reset();
        boolean pruneTriggered = false;
        BufferBuilder bufferBuilder = this.getBufferBuilder(targetChannel, isBroadcast);
        RecordSerializer.SerializationResult result = this.serializer.copyToBufferBuilder(bufferBuilder);
        while (result.isFullBuffer()) {
            this.updateMetrics(bufferBuilder, isBroadcast);
            if (result.isFullRecord()) {
                pruneTriggered = true;
                break;
            }
            bufferBuilder = this.requestNewBufferBuilder(targetChannel, isBroadcast);
            result = this.serializer.copyToBufferBuilder(bufferBuilder);
        }
        Preconditions.checkState((!this.serializer.hasSerializedData() ? 1 : 0) != 0, (Object)"All data should be written at once");
        if (flushAlways) {
            if (isBroadcast) {
                this.flushAll();
            } else {
                this.flush(targetChannel);
            }
        }
        return pruneTriggered;
    }

    @VisibleForTesting
    void closeBufferBuilder(int targetChannel) {
        if (this.bufferBuilders[targetChannel].isPresent()) {
            this.bufferBuilders[targetChannel].get().finish();
            this.bufferBuilders[targetChannel] = Optional.empty();
        }
    }

    @Override
    public void clearBuffers() {
        for (int targetChannel = 0; targetChannel < this.subpartitions.length; ++targetChannel) {
            this.closeBufferBuilder(targetChannel);
        }
    }

    @Override
    public void setTypeSerializer(TypeSerializer typeSerializer) {
        super.setTypeSerializer(typeSerializer);
        this.serializationDelegate = new SerializationDelegate(typeSerializer);
    }

    @Override
    public ResultPartitionType getResultPartitionType() {
        return this.partitionType;
    }

    @Override
    public void setMetricGroup(TaskIOMetricGroup metrics, boolean enableTracingMetrics, int tracingMetricsInterval) {
        super.setMetricGroup(metrics, enableTracingMetrics, tracingMetricsInterval);
        this.numRecordsSent = metrics.getNumRecordsSent();
        this.enableTracingMetrics = enableTracingMetrics;
        this.tracingMetricsInterval = tracingMetricsInterval;
        if (enableTracingMetrics) {
            this.nsWaitBufferTime = metrics.getNsWaitBufferTime();
        }
    }

    private void beginTracing() {
        if (this.enableTracingMetrics && this.resultCounter++ % (long)this.tracingMetricsInterval == 0L) {
            this.traceTriggered = true;
            this.waitOutputForCurrentRecord = 0L;
        } else {
            this.traceTriggered = false;
        }
    }

    private void endTracing(long count) {
        if (this.traceTriggered) {
            this.nsWaitBufferTime.update(count, this.waitOutputForCurrentRecord);
        }
        if (this.numRecordsSent != null) {
            this.numRecordsSent.inc(count);
        }
    }

    @VisibleForTesting
    AtomicBoolean[] getConsumerEventTriggered() {
        return this.consumerEventTriggered;
    }

    @VisibleForTesting
    ArrayDeque<ConsumerEvent>[] getConsumerEvents() {
        return this.consumerEvents;
    }

    @VisibleForTesting
    Optional<BufferBuilder>[] getBufferBuilders() {
        return this.bufferBuilders;
    }

    static enum ConsumerEventType {
        DISCONNECTED,
        CONNECTED;

    }

    static class ConsumerEvent {
        private final ConsumerEventType type;
        private final ResultSubpartitionView view;

        public ConsumerEvent(ConsumerEventType type, ResultSubpartitionView view) {
            this.type = (ConsumerEventType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            this.view = (ResultSubpartitionView)Preconditions.checkNotNull((Object)view);
        }

        public ConsumerEventType getType() {
            return this.type;
        }

        public ResultSubpartitionView getView() {
            return this.view;
        }
    }

    public static enum ConsumerFailureBehavior {
        NOTHING,
        DRAIN;

    }
}

