/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.ArrayDeque;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.InternalResultPartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ProducerFailedException;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PipelinedSubpartition
extends ResultSubpartition {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedSubpartition.class);
    protected PipelinedSubpartitionView readView;
    private boolean isFinished;
    @GuardedBy(value="buffers")
    private boolean flushRequested;
    private volatile boolean isReleased;

    PipelinedSubpartition(int index, InternalResultPartition parent) {
        super(index, parent);
    }

    @Override
    public boolean add(BufferConsumer bufferConsumer) throws IOException {
        return this.add(bufferConsumer, false);
    }

    @Override
    public void finish() throws IOException {
        this.add(EventSerializer.toBufferConsumer(EndOfPartitionEvent.INSTANCE), true);
        LOG.debug("Finished {}.", (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(BufferConsumer bufferConsumer, boolean finish) {
        boolean notifyDataAvailable;
        Preconditions.checkNotNull((Object)bufferConsumer);
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isFinished || this.isReleased) {
                bufferConsumer.close();
                return false;
            }
            this.buffers.add(bufferConsumer);
            this.updateStatistics(bufferConsumer);
            this.increaseBuffersInBacklog(bufferConsumer);
            notifyDataAvailable = this.shouldNotifyDataAvailable() || finish;
            this.isFinished |= finish;
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws IOException {
        PipelinedSubpartitionView view;
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isReleased) {
                return;
            }
            for (BufferConsumer buffer : this.buffers) {
                buffer.close();
            }
            this.buffers.clear();
            view = this.readView;
            this.readView = null;
            this.isReleased = true;
        }
        LOG.debug("Released {}.", (Object)this);
        if (view != null && !view.isReleased()) {
            view.notifyDataAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    ResultSubpartition.BufferAndBacklog pollBuffer() {
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.isReleased) {
                if (this.getFailureCause() != null) {
                    throw new ProducerFailedException(this.getFailureCause());
                }
                throw new ProducerFailedException(new IllegalStateException("Result subpartition[" + this.toString() + "] has been released"));
            }
            Buffer buffer = null;
            if (this.buffers.isEmpty()) {
                this.updateFlushRequestedFlag(false);
            }
            while (!this.buffers.isEmpty()) {
                BufferConsumer bufferConsumer = (BufferConsumer)this.buffers.peek();
                buffer = bufferConsumer.build();
                Preconditions.checkState((bufferConsumer.isFinished() || this.buffers.size() == 1 ? 1 : 0) != 0, (Object)"When there are multiple buffers, an unfinished bufferConsumer can not be at the head of the buffers queue.");
                if (this.buffers.size() == 1) {
                    this.updateFlushRequestedFlag(false);
                }
                if (bufferConsumer.isFinished()) {
                    ((BufferConsumer)this.buffers.pop()).close();
                    this.decreaseBuffersInBacklogUnsafe(bufferConsumer.isBuffer());
                }
                if (buffer.readableBytes() > 0) break;
                buffer.recycleBuffer();
                buffer = null;
                if (bufferConsumer.isFinished()) continue;
                break;
            }
            if (buffer == null) {
                return null;
            }
            this.updateStatistics(buffer);
            return new ResultSubpartition.BufferAndBacklog(buffer, this.isAvailableUnsafe(), this.getBuffersInBacklog(), this._nextBufferIsEvent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean nextBufferIsEvent() {
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            return this._nextBufferIsEvent();
        }
    }

    private boolean _nextBufferIsEvent() {
        assert (Thread.holdsLock(this.buffers));
        return !this.buffers.isEmpty() && !((BufferConsumer)this.buffers.peekFirst()).isBuffer();
    }

    @Override
    public int releaseMemory() {
        return 0;
    }

    @Override
    public boolean isReleased() {
        return this.isReleased;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PipelinedSubpartitionView createReadView(BufferAvailabilityListener availabilityListener) throws IOException {
        boolean notifyDataAvailable;
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            Preconditions.checkState((!this.isReleased ? 1 : 0) != 0);
            Preconditions.checkState((this.readView == null ? 1 : 0) != 0, (String)"Subpartition %s of is being (or already has been) consumed, but pipelined subpartitions can only be consumed once.", (Object[])new Object[]{this.index, this.parent.getPartitionId()});
            LOG.debug("Creating read view for subpartition {} of partition {}.", (Object)this.index, (Object)this.parent.getPartitionId());
            this.readView = new PipelinedSubpartitionView(this, availabilityListener);
            notifyDataAvailable = !this.buffers.isEmpty();
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
        return this.readView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable() {
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            return this.isAvailableUnsafe();
        }
    }

    private boolean isAvailableUnsafe() {
        return this.flushRequested || this.getNumberOfFinishedBuffers() > 0;
    }

    int getCurrentNumberOfBuffers() {
        return this.buffers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean hasReadView;
        boolean finished;
        long numBytes;
        long numBuffers;
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            numBuffers = this.getTotalNumberOfBuffers();
            numBytes = this.getTotalNumberOfBytes();
            finished = this.isFinished;
            hasReadView = this.readView != null;
        }
        return String.format("PipelinedSubpartition %d of %s [number of buffers: %d (%d bytes), number of buffers in backlog: %d, finished? %s, read view? %s]", this.index, this.parent.getPartitionId(), numBuffers, numBytes, this.getBuffersInBacklog(), finished, hasReadView);
    }

    @Override
    public int unsynchronizedGetNumberOfQueuedBuffers() {
        return Math.max(this.buffers.size(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        boolean notifyDataAvailable;
        ArrayDeque arrayDeque = this.buffers;
        synchronized (arrayDeque) {
            if (this.buffers.isEmpty()) {
                return;
            }
            notifyDataAvailable = !this.flushRequested && this.buffers.size() == 1 && ((BufferConsumer)this.buffers.peek()).isDataAvailable();
            this.updateFlushRequestedFlag(this.flushRequested || this.buffers.size() > 1 || notifyDataAvailable);
        }
        if (notifyDataAvailable) {
            this.notifyDataAvailable();
        }
    }

    private boolean shouldNotifyDataAvailable() {
        return this.readView != null && !this.flushRequested && this.getNumberOfFinishedBuffers() == 1;
    }

    protected void notifyDataAvailable() {
        if (this.readView != null) {
            this.readView.notifyDataAvailable();
        }
    }

    void updateFlushRequestedFlag(boolean flushRequested) {
        assert (Thread.holdsLock(this.buffers));
        this.flushRequested = flushRequested;
    }

    private int getNumberOfFinishedBuffers() {
        assert (Thread.holdsLock(this.buffers));
        if (this.buffers.size() == 1 && ((BufferConsumer)this.buffers.peekLast()).isFinished()) {
            return 1;
        }
        return Math.max(0, this.buffers.size() - 1);
    }
}

