/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.ProducerFailedException;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.Preconditions;

class PipelinedSubpartitionView
implements ResultSubpartitionView {
    private final PipelinedSubpartition parent;
    private final BufferAvailabilityListener availabilityListener;
    private final AtomicBoolean isReleased;
    private volatile Throwable failureCause;
    private volatile boolean isConsumable;

    PipelinedSubpartitionView(PipelinedSubpartition parent, BufferAvailabilityListener listener) {
        this(parent, listener, true);
    }

    PipelinedSubpartitionView(PipelinedSubpartition parent, BufferAvailabilityListener listener, boolean isConsumable) {
        this.parent = (PipelinedSubpartition)Preconditions.checkNotNull((Object)parent);
        this.availabilityListener = (BufferAvailabilityListener)Preconditions.checkNotNull((Object)listener);
        this.isReleased = new AtomicBoolean();
        this.isConsumable = isConsumable;
    }

    @Override
    @Nullable
    public ResultSubpartition.BufferAndBacklog getNextBuffer() throws IOException, InterruptedException {
        if (this.isReleased.get()) {
            if (this.failureCause != null) {
                if (this.failureCause instanceof IOException) {
                    throw (IOException)this.failureCause;
                }
                throw new IllegalStateException("Try to get buffer from released view " + this, this.failureCause);
            }
            throw new IllegalStateException("Try to get buffer from released view " + this);
        }
        if (this.parent.isReleased()) {
            if (this.parent.getFailureCause() != null) {
                throw new ProducerFailedException(this.parent.getFailureCause());
            }
            throw new ProducerFailedException(new IllegalStateException("Try to get buffer from released subpartition " + this.parent));
        }
        if (!this.isConsumable) {
            return null;
        }
        return this.parent.pollBuffer();
    }

    @Override
    public void notifyDataAvailable() {
        this.availabilityListener.notifyDataAvailable();
    }

    @Override
    public void releaseAllResources(@Nullable Throwable throwable) {
        if (this.isReleased.compareAndSet(false, true)) {
            if (throwable == null) {
                this.parent.onConsumedSubpartition();
            } else {
                this.failureCause = throwable;
                this.parent.onSubpartitionConsumingFailure(this, throwable);
            }
        }
    }

    @Override
    public boolean isReleased() {
        return this.isReleased.get();
    }

    @Override
    public boolean nextBufferIsEvent() {
        return this.parent.nextBufferIsEvent();
    }

    @Override
    public boolean isAvailable() {
        return this.parent.isAvailable() || this.isReleased.get() || this.parent.isReleased();
    }

    @Override
    public void notifyCreditAdded(int creditDeltas) {
    }

    @Override
    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public void allowConsuming() {
        this.isConsumable = true;
    }

    public boolean isConsumable() {
        return this.isConsumable;
    }

    public String toString() {
        return String.format("PipelinedSubpartitionView(index: %d) of InternalResultPartition %s", this.parent.index, this.parent.parent.getPartitionId());
    }
}

