/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultPartition<T>
implements ResultPartitionWriter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ResultPartition.class);
    private final String owningTaskName;
    protected final JobID jobId;
    protected final ResultPartitionID partitionId;
    protected final ResultPartitionType partitionType;
    protected final int numberOfSubpartitions;
    public final int numTargetKeyGroups;
    protected Counter numBytesOut = new SimpleCounter();
    protected Counter numBuffersOut = new SimpleCounter();
    protected TypeSerializer typeSerializer;
    protected SerializationDelegate serializationDelegate;
    protected AbstractInvokable parentTask;
    protected final AtomicBoolean isReleased = new AtomicBoolean();
    protected boolean isFinished;
    private volatile Throwable cause;

    public ResultPartition(String owningTaskName, JobID jobId, ResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions, int numTargetKeyGroups) {
        this.owningTaskName = (String)Preconditions.checkNotNull((Object)owningTaskName);
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.partitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)partitionId);
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        this.numberOfSubpartitions = numberOfSubpartitions;
        this.numTargetKeyGroups = numTargetKeyGroups;
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    protected void checkInProduceState() {
        Preconditions.checkState((!this.isFinished ? 1 : 0) != 0, (Object)"Partition already finished.");
    }

    public void release() {
        this.release(null);
    }

    public void release(Throwable cause) {
        if (this.isReleased.compareAndSet(false, true)) {
            LOG.debug("{}: Releasing {}.", (Object)this.owningTaskName, (Object)this);
            if (cause != null) {
                this.cause = cause;
            }
            this.releaseInternal();
        }
    }

    public boolean isReleased() {
        return this.isReleased.get();
    }

    public Throwable getFailureCause() {
        return this.cause;
    }

    protected abstract void releaseInternal();

    public abstract void finish() throws IOException;

    @Override
    public void setTypeSerializer(TypeSerializer typeSerializer) {
        this.typeSerializer = (TypeSerializer)Preconditions.checkNotNull((Object)typeSerializer);
    }

    @Override
    public void setParentTask(AbstractInvokable parentTask) {
        this.parentTask = parentTask;
    }

    @Override
    public ResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    @Override
    public int getNumberOfSubpartitions() {
        return this.numberOfSubpartitions;
    }

    @Override
    public int getNumTargetKeyGroups() {
        return this.numTargetKeyGroups;
    }

    @Override
    public void setMetricGroup(TaskIOMetricGroup metrics, boolean enableTracingMetrics, int tracingMetricsInterval) {
        this.numBytesOut = metrics.getNumBytesOutCounter();
        this.numBuffersOut = metrics.getNumBuffersOutCounter();
    }

    @VisibleForTesting
    public Counter getNumBytesOut() {
        return this.numBytesOut;
    }

    @VisibleForTesting
    public Counter getNumBuffersOut() {
        return this.numBuffersOut;
    }
}

