/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.Set;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGateListener;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;
import org.apache.flink.shaded.guava18.com.google.common.collect.Sets;
import org.apache.flink.util.Preconditions;

public class UnionInputGate
implements InputGate,
InputGateListener {
    private final InputGate[] inputGates;
    private final Set<InputGate> inputGatesWithRemainingData;
    private final ArrayDeque<InputGate> inputGatesWithData = new ArrayDeque();
    private final Set<InputGate> enqueuedInputGatesWithData = new HashSet<InputGate>();
    private final int totalNumberOfInputChannels;
    private final List<InputGateListener> inputGateListeners = new ArrayList<InputGateListener>();
    private final Map<InputGate, Integer> inputGateToIndexOffsetMap;
    private boolean requestedPartitionsFlag;

    public UnionInputGate(InputGate ... inputGates) {
        this.inputGates = (InputGate[])Preconditions.checkNotNull((Object)inputGates);
        Preconditions.checkArgument((inputGates.length > 1 ? 1 : 0) != 0, (Object)"Union input gate should union at least two input gates.");
        this.inputGateToIndexOffsetMap = Maps.newHashMapWithExpectedSize((int)inputGates.length);
        this.inputGatesWithRemainingData = Sets.newHashSetWithExpectedSize((int)inputGates.length);
        int currentNumberOfInputChannels = 0;
        for (InputGate inputGate : inputGates) {
            this.inputGateToIndexOffsetMap.put((InputGate)Preconditions.checkNotNull((Object)inputGate), currentNumberOfInputChannels);
            this.inputGatesWithRemainingData.add(inputGate);
            currentNumberOfInputChannels += inputGate.getNumberOfInputChannels();
            inputGate.registerListener(this);
        }
        this.totalNumberOfInputChannels = currentNumberOfInputChannels;
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.totalNumberOfInputChannels;
    }

    @Override
    public InputChannel[] getAllInputChannels() {
        InputChannel[] channelArr = new InputChannel[this.totalNumberOfInputChannels];
        this.inputGateToIndexOffsetMap.forEach((inputGate, inputChannelOffset) -> {
            InputChannel[] channelArrForSubInputGate = inputGate.getAllInputChannels();
            for (int i = 0; i < channelArrForSubInputGate.length; ++i) {
                channelArr[i + inputChannelOffset.intValue()] = channelArrForSubInputGate[i];
            }
        });
        return channelArr;
    }

    @Override
    public boolean isFinished() {
        for (InputGate inputGate : this.inputGates) {
            if (inputGate.isFinished()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean moreAvailable() {
        ArrayDeque<InputGate> arrayDeque = this.inputGatesWithData;
        synchronized (arrayDeque) {
            return !this.inputGatesWithData.isEmpty();
        }
    }

    @Override
    public void requestPartitions() throws IOException, InterruptedException {
        if (!this.requestedPartitionsFlag) {
            for (InputGate inputGate : this.inputGates) {
                inputGate.requestPartitions();
            }
            this.requestedPartitionsFlag = true;
        }
    }

    @Override
    public Optional<BufferOrEvent> getNextBufferOrEvent() throws IOException, InterruptedException {
        return this.getNextBufferOrEvent(Optional.empty(), true);
    }

    @Override
    public Optional<BufferOrEvent> pollNextBufferOrEvent() throws IOException, InterruptedException {
        return this.getNextBufferOrEvent(Optional.empty(), false);
    }

    @Override
    public Optional<BufferOrEvent> pollNextBufferOrEvent(InputGate subInputGate) throws IOException, InterruptedException {
        return this.getNextBufferOrEvent(Optional.of(subInputGate), false);
    }

    @Override
    public Optional<BufferOrEvent> getNextBufferOrEvent(InputGate subInputGate) throws IOException, InterruptedException {
        Preconditions.checkNotNull((Object)subInputGate, (String)"subInputGate is null");
        return this.getNextBufferOrEvent(Optional.of(subInputGate), true);
    }

    private Optional<BufferOrEvent> getNextBufferOrEvent(Optional<InputGate> subInputGate, boolean blocking) throws IOException, InterruptedException {
        if (subInputGate.isPresent() ? !this.inputGatesWithRemainingData.contains(subInputGate.get()) : this.inputGatesWithRemainingData.isEmpty()) {
            return Optional.empty();
        }
        this.requestPartitions();
        Optional<InputGateWithData> inputGateWithDataResult = this.waitAndGetNextInputGate(subInputGate, blocking);
        if (!blocking && !inputGateWithDataResult.isPresent()) {
            return Optional.empty();
        }
        InputGateWithData inputGateWithData = inputGateWithDataResult.get();
        InputGate inputGate = inputGateWithData.inputGate;
        BufferOrEvent bufferOrEvent = inputGateWithData.bufferOrEvent;
        if (bufferOrEvent.moreAvailable()) {
            this.queueInputGate(inputGate);
        }
        if (bufferOrEvent.isEvent() && bufferOrEvent.getEvent().getClass() == EndOfPartitionEvent.class && inputGate.isFinished()) {
            Preconditions.checkState((!bufferOrEvent.moreAvailable() ? 1 : 0) != 0);
            if (!this.inputGatesWithRemainingData.remove(inputGate)) {
                throw new IllegalStateException("Couldn't find input gate in set of remaining input gates.");
            }
        }
        int channelIndexOffset = this.inputGateToIndexOffsetMap.get(inputGate);
        bufferOrEvent.setChannelIndex(channelIndexOffset + bufferOrEvent.getChannelIndex());
        bufferOrEvent.setMoreAvailable(bufferOrEvent.moreAvailable() || inputGateWithData.moreInputGatesAvailable);
        return Optional.of(bufferOrEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<InputGateWithData> waitAndGetNextInputGate(Optional<InputGate> nextInputGateOptional, boolean blocking) throws IOException, InterruptedException {
        boolean moreInputGatesAvailable;
        InputGate inputGate;
        Optional<BufferOrEvent> bufferOrEvent;
        if (nextInputGateOptional.isPresent()) {
            Optional<BufferOrEvent> bufferOrEvent2;
            InputGate inputGate2 = nextInputGateOptional.get();
            Optional<BufferOrEvent> optional = bufferOrEvent2 = blocking ? inputGate2.getNextBufferOrEvent() : inputGate2.pollNextBufferOrEvent();
            if (bufferOrEvent2.isPresent()) {
                boolean moreInputGatesAvailable2;
                ArrayDeque<InputGate> arrayDeque = this.inputGatesWithData;
                synchronized (arrayDeque) {
                    if (this.enqueuedInputGatesWithData.size() == 1 && this.enqueuedInputGatesWithData.contains(inputGate2)) {
                        this.inputGatesWithData.remove(inputGate2);
                        this.enqueuedInputGatesWithData.remove(inputGate2);
                    }
                    moreInputGatesAvailable2 = this.enqueuedInputGatesWithData.size() > 0;
                }
                return Optional.of(new InputGateWithData(inputGate2, bufferOrEvent2.get(), moreInputGatesAvailable2));
            }
            if (blocking) {
                throw new IOException("Couldn't read a finished input gate.");
            }
            return Optional.empty();
        }
        do {
            ArrayDeque<InputGate> moreInputGatesAvailable3 = this.inputGatesWithData;
            synchronized (moreInputGatesAvailable3) {
                while (this.inputGatesWithData.size() == 0) {
                    if (blocking) {
                        this.inputGatesWithData.wait();
                        continue;
                    }
                    return Optional.empty();
                }
                inputGate = this.inputGatesWithData.remove();
                this.enqueuedInputGatesWithData.remove(inputGate);
                moreInputGatesAvailable = this.enqueuedInputGatesWithData.size() > 0;
            }
        } while (!(bufferOrEvent = inputGate.pollNextBufferOrEvent()).isPresent());
        return Optional.of(new InputGateWithData(inputGate, bufferOrEvent.get(), moreInputGatesAvailable));
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        for (InputGate inputGate : this.inputGates) {
            inputGate.sendTaskEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(InputGateListener listener) {
        List<InputGateListener> list = this.inputGateListeners;
        synchronized (list) {
            this.inputGateListeners.add(listener);
        }
    }

    @Override
    public int getPageSize() {
        int pageSize = -1;
        for (InputGate gate : this.inputGates) {
            if (pageSize == -1) {
                pageSize = gate.getPageSize();
                continue;
            }
            if (gate.getPageSize() == pageSize) continue;
            throw new IllegalStateException("Found input gates with different page sizes.");
        }
        return pageSize;
    }

    @Override
    public int getSubInputGateCount() {
        return this.inputGates.length;
    }

    @Override
    public InputGate getSubInputGate(int index) {
        return this.inputGates[index];
    }

    @Override
    public void notifyInputGateNonEmpty(InputGate inputGate) {
        this.queueInputGate((InputGate)Preconditions.checkNotNull((Object)inputGate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueInputGate(InputGate inputGate) {
        int availableInputGates;
        SequencedCollection<Object> sequencedCollection = this.inputGatesWithData;
        synchronized (sequencedCollection) {
            if (this.enqueuedInputGatesWithData.contains(inputGate)) {
                return;
            }
            availableInputGates = this.inputGatesWithData.size();
            this.inputGatesWithData.add(inputGate);
            this.enqueuedInputGatesWithData.add(inputGate);
            if (availableInputGates == 0) {
                this.inputGatesWithData.notifyAll();
            }
        }
        if (availableInputGates == 0) {
            sequencedCollection = this.inputGateListeners;
            synchronized (sequencedCollection) {
                for (InputGateListener listener : this.inputGateListeners) {
                    listener.notifyInputGateNonEmpty(this);
                }
            }
        }
    }

    private static class InputGateWithData {
        private final InputGate inputGate;
        private final BufferOrEvent bufferOrEvent;
        private final boolean moreInputGatesAvailable;

        InputGateWithData(InputGate inputGate, BufferOrEvent bufferOrEvent, boolean moreInputGatesAvailable) {
            this.inputGate = (InputGate)Preconditions.checkNotNull((Object)inputGate);
            this.bufferOrEvent = (BufferOrEvent)Preconditions.checkNotNull((Object)bufferOrEvent);
            this.moreInputGatesAvailable = moreInputGatesAvailable;
        }
    }
}

