/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.util.Preconditions;

class UnknownInputChannel
extends InputChannel {
    private final ResultPartitionManager partitionManager;
    private final TaskEventDispatcher taskEventDispatcher;
    private final ConnectionManager connectionManager;
    private final int initialBackoff;
    private final int maxBackoff;
    private final TaskIOMetricGroup metrics;

    public UnknownInputChannel(SingleInputGate gate, int channelIndex, ResultPartitionID partitionId, ResultPartitionManager partitionManager, TaskEventDispatcher taskEventDispatcher, ConnectionManager connectionManager, int initialBackoff, int maxBackoff, TaskIOMetricGroup metrics) {
        super(gate, channelIndex, partitionId, initialBackoff, maxBackoff, null);
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.taskEventDispatcher = (TaskEventDispatcher)Preconditions.checkNotNull((Object)taskEventDispatcher);
        this.connectionManager = (ConnectionManager)Preconditions.checkNotNull((Object)connectionManager);
        this.metrics = (TaskIOMetricGroup)Preconditions.checkNotNull((Object)metrics);
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
    }

    @Override
    public void requestSubpartition(int subpartitionIndex) throws IOException {
    }

    @Override
    public Optional<InputChannel.BufferAndAvailability> getNextBuffer() throws IOException {
        throw new UnsupportedOperationException("Cannot retrieve a buffer from an UnknownInputChannel");
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
    }

    @Override
    public boolean isReleased() {
        return false;
    }

    @Override
    public void releaseAllResources(Throwable throwable) throws IOException {
    }

    public String toString() {
        return "UnknownInputChannel [" + this.partitionId + "]";
    }

    public RemoteInputChannel toRemoteInputChannel(ConnectionID producerAddress, ResultPartitionID resultPartitionID) {
        return new RemoteInputChannel(this.inputGate, this.channelIndex, resultPartitionID, (ConnectionID)Preconditions.checkNotNull((Object)producerAddress), this.connectionManager, this.initialBackoff, this.maxBackoff, this.metrics);
    }

    public LocalInputChannel toLocalInputChannel(ResultPartitionID resultPartitionID) {
        return new LocalInputChannel(this.inputGate, this.channelIndex, resultPartitionID, this.partitionManager, this.taskEventDispatcher, this.initialBackoff, this.maxBackoff, this.metrics);
    }
}

