/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleUtils;
import org.apache.flink.runtime.io.network.partition.external.HashPartitionIndices;
import org.apache.flink.runtime.io.network.partition.external.LocalResultPartitionResolver;
import org.apache.flink.runtime.io.network.partition.external.MergedPartitionIndices;
import org.apache.flink.runtime.io.network.partition.external.OsCachePolicy;
import org.apache.flink.runtime.io.network.partition.external.PartitionIndices;
import org.apache.flink.runtime.io.network.partition.external.PersistentFileType;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExternalBlockResultPartitionMeta {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalBlockResultPartitionMeta.class);
    public static final int SUPPORTED_PROTOCOL_VERSION = 1;
    private final ResultPartitionID resultPartitionID;
    private final FileSystem fileSystem;
    private final OsCachePolicy osCachePolicy;
    private final long maxReadAheadLength;
    @GuardedBy(value="this")
    private volatile boolean hasInitialized = false;
    private PersistentFileType externalFileType = PersistentFileType.UNDEFINED;
    private final LocalResultPartitionResolver.ResultPartitionFileInfo fileInfo;
    private int spillCount = 1;
    private int subpartitionNum = 0;
    private List<PartitionIndices> partitionIndicesList;
    private final AtomicInteger unconsumedSubpartitionCount = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final AtomicReference<Long> lastActiveTimeInMs = new AtomicReference<Long>(-1L);

    ExternalBlockResultPartitionMeta(ResultPartitionID resultPartitionID, FileSystem fileSystem, LocalResultPartitionResolver.ResultPartitionFileInfo fileInfo, OsCachePolicy osCachePolicy, long maxReadAheadLength) {
        this.resultPartitionID = resultPartitionID;
        this.fileSystem = fileSystem;
        this.fileInfo = fileInfo;
        this.osCachePolicy = osCachePolicy;
        this.maxReadAheadLength = maxReadAheadLength;
    }

    boolean hasInitialized() {
        return this.hasInitialized;
    }

    synchronized void initialize() throws IOException {
        if (this.hasInitialized) {
            return;
        }
        this.initializeByFinishFile();
        this.initializeByIndexFile();
        this.unconsumedSubpartitionCount.set(this.subpartitionNum);
        this.lastActiveTimeInMs.set(System.currentTimeMillis());
        this.hasInitialized = true;
    }

    public String getRootDir() {
        return this.fileInfo.getRootDir();
    }

    public String getResultPartitionDir() {
        return this.fileInfo.getPartitionDir();
    }

    public OsCachePolicy getOsCachePolicy() {
        return this.osCachePolicy;
    }

    public long getMaxReadAheadLength() {
        return this.maxReadAheadLength;
    }

    public synchronized List<ExternalSubpartitionMeta> getSubpartitionMeta(int subpartitionIndex) throws IOException {
        Preconditions.checkState((boolean)this.hasInitialized, (Object)"The meta info has not been initialized.");
        Preconditions.checkArgument((subpartitionIndex >= 0 && subpartitionIndex < this.subpartitionNum ? 1 : 0) != 0, (Object)"Invalid subpartition index.");
        ArrayList<ExternalSubpartitionMeta> subpartitionMeta = new ArrayList<ExternalSubpartitionMeta>(this.spillCount);
        for (PartitionIndices partitionIndices : this.partitionIndicesList) {
            subpartitionMeta.add(partitionIndices.getSubpartitionMeta(subpartitionIndex));
        }
        return subpartitionMeta;
    }

    PersistentFileType getExternalBlockFileType() {
        if (this.hasInitialized()) {
            return this.externalFileType;
        }
        throw new RuntimeException("This method should be called after initialize()");
    }

    long getConsumedPartitionTTL() {
        return this.fileInfo.getConsumedPartitionTTL();
    }

    long getPartialConsumedPartitionTTL() {
        return this.fileInfo.getPartialConsumedPartitionTTL();
    }

    void notifySubpartitionStartConsuming(int subpartitionIndex) {
        this.lastActiveTimeInMs.set(System.currentTimeMillis());
        this.refCount.addAndGet(1);
    }

    void notifySubpartitionConsumed(int subpartitionIndex) {
        long currTime = System.currentTimeMillis();
        if (this.unconsumedSubpartitionCount.decrementAndGet() < 1 && LOG.isDebugEnabled()) {
            LOG.debug("Partition {} 's reference count turn to zero at {}", (Object)this.resultPartitionID, (Object)currTime);
        }
        this.lastActiveTimeInMs.set(currTime);
        this.refCount.decrementAndGet();
    }

    int getReferenceCount() {
        return this.refCount.get();
    }

    int getUnconsumedSubpartitionCount() {
        int count = this.unconsumedSubpartitionCount.get();
        return count >= 0 ? count : 0;
    }

    long getLastActiveTimeInMs() {
        return this.lastActiveTimeInMs.get();
    }

    @VisibleForTesting
    ResultPartitionID getResultPartitionID() {
        return this.resultPartitionID;
    }

    long getShrinkableMemoryFootprint() {
        long shrinkableMemoryFootprint = 0L;
        for (PartitionIndices partitionIndices : this.partitionIndicesList) {
            shrinkableMemoryFootprint += partitionIndices.getShrinkableMemoryFootprint();
        }
        return shrinkableMemoryFootprint;
    }

    long shrinkMemoryFootprint() {
        long shrunkMemoryFootprint = 0L;
        for (PartitionIndices partitionIndices : this.partitionIndicesList) {
            shrunkMemoryFootprint += partitionIndices.shrinkMemoryFootprint();
        }
        return shrunkMemoryFootprint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeByFinishFile() throws IOException {
        String finishedPathStr = ExternalBlockShuffleUtils.generateFinishedPath(this.fileInfo.getPartitionDir());
        Path finishFilePath = new Path(finishedPathStr);
        if (!this.fileSystem.exists(finishFilePath)) {
            throw new IOException("Finish file doesn't exist, file path: " + finishFilePath.getPath());
        }
        FSDataInputStream finishIn = null;
        try {
            finishIn = this.fileSystem.open(finishFilePath);
            if (null == finishIn) {
                throw new IOException("Cannot open finish file, file path: " + finishedPathStr);
            }
            DataInputViewStreamWrapper finishView = new DataInputViewStreamWrapper((InputStream)finishIn);
            int version = finishView.readInt();
            if (version > 1) {
                throw new RuntimeException("Unsupported External Data version: " + version + ", supported version: " + 1);
            }
            int typeLength = finishView.readInt();
            byte[] typeContent = new byte[typeLength];
            finishView.read(typeContent);
            this.externalFileType = PersistentFileType.valueOf(new String(typeContent));
            if (this.externalFileType != PersistentFileType.MERGED_PARTITION_FILE && this.externalFileType != PersistentFileType.HASH_PARTITION_FILE) {
                throw new RuntimeException("Unknown external file type: " + typeContent);
            }
            this.spillCount = finishView.readInt();
            if (this.externalFileType == PersistentFileType.HASH_PARTITION_FILE) {
                if (this.spillCount != 1) {
                    throw new RuntimeException("Spill count [" + this.spillCount + "] should be 1 in HASH_PARTITION_FILE mode.");
                }
            } else if (this.spillCount < 0) {
                throw new RuntimeException("Spill count [" + this.spillCount + "] should not be negative in MULTI_SUBPARTITION_FILE mode");
            }
            this.subpartitionNum = finishView.readInt();
            if (this.subpartitionNum <= 0) {
                throw new RuntimeException("Subpartition number [" + this.subpartitionNum + "] should be positive");
            }
        }
        finally {
            if (null != finishIn) {
                finishIn.close();
            }
        }
    }

    private void initializeByIndexFile() throws IOException {
        this.partitionIndicesList = new ArrayList<PartitionIndices>(this.spillCount);
        for (int i = 0; i < this.spillCount; ++i) {
            PartitionIndices partitionIndices = null;
            partitionIndices = this.externalFileType == PersistentFileType.MERGED_PARTITION_FILE ? new MergedPartitionIndices(this.fileSystem, this.fileInfo.getPartitionDir(), i, this.subpartitionNum) : new HashPartitionIndices(this.fileSystem, this.fileInfo.getPartitionDir(), this.subpartitionNum);
            partitionIndices.initialize();
            this.partitionIndicesList.add(partitionIndices);
        }
    }

    private static String convertSubpartitionMetasToString(List<ExternalSubpartitionMeta> subpartitionMeta) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("subpartition metas' detail: {");
        for (ExternalSubpartitionMeta meta : subpartitionMeta) {
            stringBuilder.append(meta.toString());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static final class ExternalSubpartitionMeta {
        private final Path dataFile;
        private final long offset;
        private final long length;

        ExternalSubpartitionMeta(Path dataFile, long offset, long length) {
            Preconditions.checkArgument((dataFile != null ? 1 : 0) != 0);
            Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0);
            Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
            this.dataFile = dataFile;
            this.offset = offset;
            this.length = length;
        }

        Path getDataFile() {
            return this.dataFile;
        }

        long getOffset() {
            return this.offset;
        }

        long getLength() {
            return this.length;
        }

        public String toString() {
            return "{ dataFilePath = " + this.dataFile + ", offset = " + this.offset + ", buffNum = " + this.length + " }";
        }
    }
}

