/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.netty.NettyBufferPool;
import org.apache.flink.runtime.io.network.netty.NettyConfig;
import org.apache.flink.runtime.io.network.netty.NettyProtocol;
import org.apache.flink.runtime.io.network.netty.NettyServer;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleServiceConfiguration;

public class ExternalBlockShuffleService {
    private final ExternalBlockShuffleServiceConfiguration shuffleServiceConfiguration;
    private final ExternalBlockResultPartitionManager partitionProvider;
    private final NettyServer server;
    private final NettyBufferPool bufferPool;

    public ExternalBlockShuffleService(Configuration configuration) throws Exception {
        this.shuffleServiceConfiguration = ExternalBlockShuffleServiceConfiguration.fromConfiguration(configuration);
        this.partitionProvider = new ExternalBlockResultPartitionManager(this.shuffleServiceConfiguration);
        NettyConfig nettyConfig = this.shuffleServiceConfiguration.getNettyConfig();
        this.bufferPool = new NettyBufferPool(nettyConfig.getNumberOfArenas(), nettyConfig.getMaxOrder(), nettyConfig.getChunkSize());
        this.server = new NettyServer(nettyConfig);
    }

    public void start() throws IOException {
        TaskEventDispatcher taskEventDispatcher = new TaskEventDispatcher();
        NettyProtocol protocol = new NettyProtocol(this.partitionProvider, taskEventDispatcher, true);
        this.server.init(protocol, this.bufferPool);
    }

    public void stop() {
        this.server.shutdown();
        this.partitionProvider.stop();
    }

    public void initializeApplication(String user, String appId) {
        this.partitionProvider.initializeApplication(user, appId);
    }

    public void stopApplication(String appId) {
        this.partitionProvider.stopApplication(appId);
    }
}

