/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockSubpartitionView;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockSubpartitionViewScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalBlockSubpartitionViewSchedulerDelegate
extends AbstractQueue<Runnable>
implements BlockingQueue<Runnable> {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalBlockSubpartitionViewSchedulerDelegate.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private int size = 0;
    private final ExternalBlockSubpartitionViewScheduler scheduler;

    public ExternalBlockSubpartitionViewSchedulerDelegate(ExternalBlockSubpartitionViewScheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Runnable runnable) {
        ExternalBlockSubpartitionView subpartitionView = (ExternalBlockSubpartitionView)runnable;
        if (subpartitionView == null) {
            return false;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size == Integer.MAX_VALUE) {
                throw new ArithmeticException("Cannot accept subpartition view, queue size reaches Integer.MAX_VALUE");
            }
            this.scheduler.addToSchedule(subpartitionView);
            ++this.size;
            this.notEmpty.signal();
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    @Override
    public boolean offer(Runnable runnable, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(runnable);
    }

    @Override
    public void put(Runnable runnable) throws InterruptedException {
        this.offer(runnable);
    }

    @Override
    public Runnable poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            ExternalBlockSubpartitionView externalBlockSubpartitionView = this.dequeue();
            return externalBlockSubpartitionView;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        ExternalBlockSubpartitionView result;
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            while ((result = this.dequeue()) == null && nanos > 0L) {
                nanos = this.notEmpty.awaitNanos(nanos);
            }
        }
        finally {
            lock.unlock();
        }
        return result;
    }

    @Override
    public Runnable take() throws InterruptedException {
        ExternalBlockSubpartitionView result;
        this.lock.lockInterruptibly();
        try {
            while ((result = this.dequeue()) == null) {
                this.notEmpty.await();
            }
        }
        finally {
            this.lock.unlock();
        }
        return result;
    }

    @Override
    public int drainTo(Collection<? super Runnable> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super Runnable> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = Math.min(this.size, maxElements);
            for (int i = 0; i < n; ++i) {
                c.add(this.dequeue());
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.size;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Runnable peek() {
        throw new RuntimeException("Unsupported method.");
    }

    @Override
    public Iterator<Runnable> iterator() {
        throw new RuntimeException("Unsupported method.");
    }

    private final ExternalBlockSubpartitionView dequeue() {
        ExternalBlockSubpartitionView subpartitionView = this.scheduler.schedule();
        if (subpartitionView != null) {
            int n = this.size - 1;
            if (n >= 0) {
                this.size = n;
            }
        } else if (this.size != 0) {
            LOG.warn("size in ExternalBlockSubpartitionViewScheduler should be 0 because there is no ExternalBlockSubpartitionView, while the actual size is " + this.size);
            this.size = 0;
        }
        return subpartitionView;
    }
}

