/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.external.FadvisedSynchronousBufferFileReader;
import org.apache.flink.runtime.io.network.partition.external.OsCachePolicy;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.io.ReadaheadPool;

public class FadvisedReadAheadSynchronousBufferFileReader
extends FadvisedSynchronousBufferFileReader {
    private final long maxReadAheadLength;
    private final ReadaheadPool readaheadPool;
    private ReadaheadPool.ReadaheadRequest readaheadRequest = null;

    public FadvisedReadAheadSynchronousBufferFileReader(FileIOChannel.ID channelID, boolean writeEnabled, long startOffset, long length, long maxReadAheadLength, ReadaheadPool readaheadPool) throws IOException {
        super(channelID, writeEnabled, OsCachePolicy.READ_AHEAD, startOffset, length);
        this.maxReadAheadLength = maxReadAheadLength;
        this.readaheadPool = (ReadaheadPool)Preconditions.checkNotNull((Object)readaheadPool);
    }

    @Override
    public void readInto(Buffer buffer, long length) throws IOException {
        this.readaheadRequest = this.readaheadPool.readaheadStream(this.fileIdentifier, this.fd, this.currentPosition, this.maxReadAheadLength, this.endOffset, this.readaheadRequest);
        super.readInto(buffer, length);
    }

    @Override
    public void close() throws IOException {
        if (this.readaheadRequest != null) {
            this.readaheadRequest.cancel();
            this.readaheadRequest = null;
        }
        super.close();
    }
}

