/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.SynchronousBufferFileReader;
import org.apache.flink.runtime.io.network.partition.external.OsCachePolicy;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.io.nativeio.NativeIO;

public class FadvisedSynchronousBufferFileReader
extends SynchronousBufferFileReader {
    protected final OsCachePolicy osCachePolicy;
    protected final long startOffset;
    protected final long endOffset;
    protected final String fileIdentifier;

    public FadvisedSynchronousBufferFileReader(FileIOChannel.ID channelID, boolean writeEnabled, OsCachePolicy osCachePolicy, long startOffset, long length) throws IOException {
        super(channelID, writeEnabled, false);
        Preconditions.checkArgument((!osCachePolicy.equals((Object)OsCachePolicy.NO_TREATMENT) ? 1 : 0) != 0);
        this.osCachePolicy = osCachePolicy;
        this.startOffset = startOffset;
        this.endOffset = startOffset + length;
        this.fileIdentifier = this.id.toString();
        if (!osCachePolicy.equals((Object)OsCachePolicy.READ_AHEAD) && this.endOffset - startOffset > 0L) {
            try {
                NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(this.fileIdentifier, this.fd, startOffset, this.endOffset - startOffset, osCachePolicy.getFadviceFlag());
            }
            catch (Throwable t) {
                LOG.warn("Failed to manage OS cache for " + this.fileIdentifier + " , os cache policy " + osCachePolicy.toString(), t);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.endOffset - this.startOffset > 0L) {
            try {
                NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(this.fileIdentifier, this.fd, this.startOffset, this.endOffset - this.startOffset, 4);
            }
            catch (Throwable t) {
                LOG.warn("Failed to manage OS cache for " + this.fileIdentifier + ", fadvise hint POSIX_FADV_DONTNEED", t);
            }
        }
        super.close();
    }
}

