/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.util.Comparator;
import java.util.PriorityQueue;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockSubpartitionView;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockSubpartitionViewScheduler;

public class LocalityBasedSubpartitionViewScheduler
implements ExternalBlockSubpartitionViewScheduler {
    @VisibleForTesting
    protected final PriorityQueue<ExternalBlockSubpartitionView> subpartitionViewQueue = new PriorityQueue<ExternalBlockSubpartitionView>(new LocalityBasedSubpartitionViewComparator());

    @Override
    public void addToSchedule(ExternalBlockSubpartitionView subpartitionView) {
        this.subpartitionViewQueue.offer(subpartitionView);
    }

    @Override
    public ExternalBlockSubpartitionView schedule() {
        return this.subpartitionViewQueue.poll();
    }

    private static class LocalityBasedSubpartitionViewComparator
    implements Comparator<ExternalBlockSubpartitionView> {
        private LocalityBasedSubpartitionViewComparator() {
        }

        @Override
        public int compare(ExternalBlockSubpartitionView o1, ExternalBlockSubpartitionView o2) {
            if (!o1.getResultPartitionDir().equals(o2.getResultPartitionDir())) {
                return o1.getResultPartitionDir().compareTo(o2.getResultPartitionDir());
            }
            return o1.getSubpartitionIndex() - o2.getSubpartitionIndex();
        }
    }
}

