/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockResultPartitionMeta;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleUtils;
import org.apache.flink.runtime.io.network.partition.external.PartitionIndices;
import org.apache.flink.util.Preconditions;

public class MergedPartitionIndices
implements PartitionIndices {
    private final FileSystem fileSystem;
    private final Path indexFilePath;
    private final Path dataFilePath;
    private final int subpartitionNum;
    @VisibleForTesting
    protected final AtomicReference<long[]> offsetArrayRef = new AtomicReference();

    public MergedPartitionIndices(FileSystem fileSystem, String partitionDir, int spillIdx, int subpartitionNum) {
        this.fileSystem = fileSystem;
        this.indexFilePath = new Path(ExternalBlockShuffleUtils.generateIndexPath(partitionDir, spillIdx));
        this.dataFilePath = new Path(ExternalBlockShuffleUtils.generateDataPath(partitionDir, spillIdx));
        this.subpartitionNum = subpartitionNum;
    }

    @Override
    public void initialize() throws IOException {
        this.offsetArrayRef.set(this.loadPartitionIndices());
    }

    @Override
    public ExternalBlockResultPartitionMeta.ExternalSubpartitionMeta getSubpartitionMeta(int subpartitionIndex) throws IOException {
        Preconditions.checkArgument((subpartitionIndex >= 0 && subpartitionIndex < this.subpartitionNum ? 1 : 0) != 0, (Object)"Invalid subpartition index.");
        long[] tmpOffsetArray = this.offsetArrayRef.get();
        if (tmpOffsetArray == null) {
            tmpOffsetArray = this.loadPartitionIndices();
            this.offsetArrayRef.set(tmpOffsetArray);
        }
        long offset = tmpOffsetArray[subpartitionIndex];
        return new ExternalBlockResultPartitionMeta.ExternalSubpartitionMeta(this.dataFilePath, offset, tmpOffsetArray[subpartitionIndex + 1] - offset);
    }

    @Override
    public long shrinkMemoryFootprint() {
        long[] tmpOffsetArray = this.offsetArrayRef.get();
        if (tmpOffsetArray != null) {
            this.offsetArrayRef.lazySet(null);
            return 8 * (this.subpartitionNum + 1);
        }
        return 0L;
    }

    @Override
    public long getShrinkableMemoryFootprint() {
        long[] tmpOffsetArray = this.offsetArrayRef.get();
        if (tmpOffsetArray != null) {
            return 8L * (long)(this.subpartitionNum + 1);
        }
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long[] loadPartitionIndices() throws IOException {
        if (!this.fileSystem.exists(this.indexFilePath)) {
            throw new IOException("Index file doesn't exist, file path: " + this.indexFilePath.getPath());
        }
        try (FSDataInputStream indexIn = this.fileSystem.open(this.indexFilePath);){
            long lengthOfPartition;
            DataInputViewStreamWrapper indexView = new DataInputViewStreamWrapper((InputStream)indexIn);
            int size = indexView.readInt();
            long[] tmpOffsetArray = new long[this.subpartitionNum + 1];
            int nextPartitionId = 0;
            long nextOffset = 0L;
            for (int i = 0; i < size; nextOffset += lengthOfPartition, ++i) {
                int partitionId = indexView.readInt();
                while (nextPartitionId < partitionId) {
                    tmpOffsetArray[nextPartitionId++] = nextOffset;
                }
                if (nextPartitionId != partitionId) {
                    throw new IOException("Got invalid partition id, expected nextPartitionId: " + nextPartitionId + ", real partitionId: " + partitionId);
                }
                long startOffset = indexView.readLong();
                lengthOfPartition = indexView.readLong();
                if (nextOffset != startOffset) {
                    throw new IOException("Offset is not continuous, partition id: " + partitionId + ", expected nextOffset: " + nextOffset + ", real startOffset: " + startOffset);
                }
                tmpOffsetArray[nextPartitionId++] = startOffset;
            }
            while (nextPartitionId < this.subpartitionNum) {
                tmpOffsetArray[nextPartitionId++] = nextOffset;
            }
            Preconditions.checkArgument((nextPartitionId == this.subpartitionNum ? 1 : 0) != 0);
            tmpOffsetArray[this.subpartitionNum] = nextOffset;
            long[] lArray = tmpOffsetArray;
            return lArray;
        }
        catch (IOException e) {
            throw new IOException("Cannot read index file, file path: " + this.indexFilePath.getPath(), e);
        }
    }
}

