/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external.writer;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.ChannelBackendMutableObjectIterator;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.external.PartitionIndex;
import org.apache.flink.runtime.io.network.partition.external.writer.PartitionIndexGenerator;
import org.apache.flink.runtime.io.network.partition.external.writer.PartitionedSortedDataFile;
import org.apache.flink.util.Preconditions;

public class ConcatPartitionedBufferSortedDataFile<T>
implements PartitionedSortedDataFile<T> {
    private final FileIOChannel.ID channel;
    private final int fileId;
    private final IOManager ioManager;
    private final BufferFileWriter streamFileWriter;
    private final PartitionIndexGenerator partitionIndexGenerator;
    private long bytesWritten;
    private boolean isWritingFinished;

    public ConcatPartitionedBufferSortedDataFile(int numberOfSubpartitions, FileIOChannel.ID channel, int fileId, IOManager ioManager) throws IOException {
        this.channel = channel;
        this.fileId = fileId;
        this.ioManager = ioManager;
        this.streamFileWriter = ioManager.createStreamFileWriter(channel);
        this.partitionIndexGenerator = new PartitionIndexGenerator(numberOfSubpartitions);
    }

    @Override
    public FileIOChannel getWriteChannel() {
        return this.streamFileWriter;
    }

    @Override
    public FileIOChannel.ID getChannelID() {
        return this.channel;
    }

    @Override
    public void writeRecord(Tuple2<Integer, T> record) throws IOException {
        throw new UnsupportedOperationException("Can not write record to concated buffer file.");
    }

    @Override
    public void copyRecord(DataInputView serializedRecord) throws IOException {
        throw new UnsupportedOperationException("Can not copy record to concated buffer file.");
    }

    @Override
    public long getBytesWritten() throws IOException {
        return this.bytesWritten;
    }

    public void writeBuffer(int subpartition, Buffer buffer) throws IOException {
        Preconditions.checkState((!this.isWritingFinished ? 1 : 0) != 0, (Object)"");
        this.partitionIndexGenerator.updatePartitionIndexBeforeWriting(subpartition, this.bytesWritten, 0L);
        this.streamFileWriter.writeBlock(buffer);
        this.bytesWritten += (long)buffer.getSize();
    }

    @Override
    public void finishWriting() throws IOException {
        if (!this.isWritingFinished) {
            this.streamFileWriter.close();
            this.partitionIndexGenerator.finishWriting(this.bytesWritten, 0L);
            this.isWritingFinished = true;
        }
    }

    @Override
    public ChannelBackendMutableObjectIterator<Tuple2<Integer, T>> createReader(List<MemorySegment> readMemory) throws IOException {
        return new ChannelBackendMutableObjectIterator<Tuple2<Integer, T>>(){

            @Override
            public FileIOChannel getReaderChannel() {
                return null;
            }

            public Tuple2<Integer, T> next(Tuple2<Integer, T> reuse) throws IOException {
                return null;
            }

            public Tuple2<Integer, T> next() throws IOException {
                return null;
            }
        };
    }

    @Override
    public List<PartitionIndex> getPartitionIndexList() {
        return this.partitionIndexGenerator.getPartitionIndices();
    }

    public int getFileId() {
        return this.fileId;
    }
}

