/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.external.writer;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.partition.external.writer.BufferSortedDataFile;
import org.apache.flink.runtime.io.network.partition.external.writer.BufferSortedDataFileFactory;
import org.apache.flink.runtime.io.network.partition.external.writer.PartitionedBufferSortedDataFile;
import org.apache.flink.runtime.operators.sort.SortedDataFile;
import org.apache.flink.runtime.operators.sort.SortedDataFileFactory;

public class PartitionedBufferSortedDataFileFactory<T>
implements SortedDataFileFactory<Tuple2<Integer, T>> {
    private final BufferSortedDataFileFactory<T> bufferSortedDataFileFactory;
    private final int numberPartitions;

    public PartitionedBufferSortedDataFileFactory(BufferSortedDataFileFactory<T> bufferSortedDataFileFactory, int numberPartitions) {
        this.bufferSortedDataFileFactory = bufferSortedDataFileFactory;
        this.numberPartitions = numberPartitions;
    }

    @Override
    public SortedDataFile<Tuple2<Integer, T>> createFile(List<MemorySegment> writeMemory) throws IOException {
        BufferSortedDataFile bufferSortedDataFile = (BufferSortedDataFile)this.bufferSortedDataFileFactory.createFile(writeMemory);
        return new PartitionedBufferSortedDataFile(this.numberPartitions, bufferSortedDataFile);
    }
}

