/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.io.FinalizeOnMaster;
import org.apache.flink.api.common.io.InitializeOnMaster;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DelegatingConfiguration;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.TaskConfig;
import org.apache.flink.runtime.util.EmptyIterator;
import org.apache.flink.runtime.util.SingleElementIterator;
import org.apache.flink.types.DefaultPair;
import org.apache.flink.types.Pair;
import org.apache.flink.util.Preconditions;

public class FormatUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeInputFormatsOnMaster(JobVertex jobVertex, AbstractFormatStub<OperatorID, ?> stub, Map<OperatorID, String> formatDescriptions) throws RuntimeException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(stub.getClassLoader());
        try {
            Iterator<Pair<OperatorID, InputFormat>> it = stub.getFormat(FormatType.INPUT);
            it.forEachRemaining(pair -> {
                OperatorID operatorID = (OperatorID)((Object)((Object)pair.getKey()));
                InputFormat inputFormat = (InputFormat)pair.getValue();
                try {
                    inputFormat.configure(stub.getParameters(operatorID));
                }
                catch (Throwable t) {
                    throw new RuntimeException("Configuring the OutputFormat (description: " + (String)formatDescriptions.get((Object)operatorID) + ", stubKey: " + (Object)((Object)operatorID) + ") failed: " + t.getMessage(), t);
                }
                jobVertex.setInputSplitSource(operatorID, (InputSplitSource<?>)inputFormat);
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeOutputFormatsOnMaster(JobVertex jobVertex, AbstractFormatStub<OperatorID, ?> stub, Map<OperatorID, String> formatDescriptions) throws RuntimeException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(stub.getClassLoader());
        try {
            Iterator<Pair<OperatorID, OutputFormat>> it = stub.getFormat(FormatType.OUTPUT);
            it.forEachRemaining(pair -> {
                OperatorID key = (OperatorID)((Object)((Object)pair.getKey()));
                OutputFormat outputFormat = (OutputFormat)pair.getValue();
                if (outputFormat instanceof InitializeOnMaster) {
                    try {
                        outputFormat.configure(stub.getParameters(key));
                        ((InitializeOnMaster)outputFormat).initializeGlobal(jobVertex.getParallelism());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Configuring the OutputFormat (description: " + (String)formatDescriptions.get((Object)key) + ", stubKey: " + (Object)((Object)key) + ") failed: " + t.getMessage(), t);
                    }
                }
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeOutputFormatsOnMaster(JobVertex jobVertex, AbstractFormatStub<OperatorID, ?> stub, Map<OperatorID, String> formatDescriptions) throws RuntimeException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(stub.getClassLoader());
        try {
            Iterator<Pair<OperatorID, OutputFormat>> it = stub.getFormat(FormatType.OUTPUT);
            it.forEachRemaining(pair -> {
                OperatorID key = (OperatorID)((Object)((Object)pair.getKey()));
                OutputFormat outputFormat = (OutputFormat)pair.getValue();
                if (outputFormat instanceof FinalizeOnMaster) {
                    try {
                        outputFormat.configure(stub.getParameters(key));
                        ((FinalizeOnMaster)outputFormat).finalizeGlobal(jobVertex.getParallelism());
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Configuring the OutputFormat (description: " + (String)formatDescriptions.get((Object)key) + ", stubKey: " + (Object)((Object)key) + ") failed: " + t.getMessage(), t);
                    }
                }
            });
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private FormatUtil() {
        throw new AssertionError();
    }

    public static abstract class AbstractFormatStub<STUB_KEY, W> {
        protected final TaskConfig config;
        protected final ClassLoader classLoader;
        protected final UserCodeWrapper<W> wrapper;
        protected final Configuration parameters;

        public AbstractFormatStub(TaskConfig config, ClassLoader classLoader) throws Exception {
            this.config = (TaskConfig)Preconditions.checkNotNull((Object)config);
            this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
            try {
                this.wrapper = config.getStubWrapper(classLoader);
                if (this.wrapper == null) {
                    throw new Exception("No " + this.getClass().getSimpleName() + " present in task configuration.");
                }
            }
            catch (Throwable t) {
                throw new Exception("Deserializing " + this.getClass().getSimpleName() + " failed: " + t.getMessage(), t);
            }
            this.parameters = config.getStubParameters();
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public abstract <F> Iterator<Pair<STUB_KEY, F>> getFormat(FormatType<F> var1);

        public abstract Configuration getParameters(STUB_KEY var1);
    }

    public static class MultiFormatStub
    extends AbstractFormatStub<OperatorID, Tuple2<Map<OperatorID, InputFormat>, Map<OperatorID, OutputFormat>>> {
        public MultiFormatStub(TaskConfig config, ClassLoader classLoader) throws Exception {
            super(config, classLoader);
        }

        @Override
        public <F> Iterator<Pair<OperatorID, F>> getFormat(FormatType<F> type) {
            Tuple2 tuple = (Tuple2)this.wrapper.getUserCodeObject(Tuple2.class, this.classLoader);
            if (type == FormatType.INPUT && tuple.f0 != null) {
                final Iterator iterator = ((Map)tuple.f0).entrySet().iterator();
                return new Iterator<Pair<OperatorID, F>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Pair<OperatorID, F> next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new DefaultPair(entry.getKey(), entry.getValue());
                    }
                };
            }
            if (type == FormatType.OUTPUT && tuple.f1 != null) {
                final Iterator iterator = ((Map)tuple.f1).entrySet().iterator();
                return new Iterator<Pair<OperatorID, F>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Pair<OperatorID, F> next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new DefaultPair(entry.getKey(), entry.getValue());
                    }
                };
            }
            return EmptyIterator.get();
        }

        @Override
        public Configuration getParameters(OperatorID operatorID) {
            return new DelegatingConfiguration(this.config.getStubParameters(), (Object)((Object)operatorID) + ".");
        }

        public static void setStubFormats(TaskConfig config, @Nullable Map<OperatorID, InputFormat> idInputFormatMap, @Nullable Map<OperatorID, OutputFormat> idOutputFormatMap) {
            config.setStubWrapper((UserCodeWrapper<?>)new UserCodeObjectWrapper((Object)new Tuple2(idInputFormatMap, idOutputFormatMap)));
        }

        public static void setStubParameters(TaskConfig config, OperatorID operatorID, Configuration parameters) {
            for (String key : parameters.keySet()) {
                config.setStubParameter((Object)((Object)operatorID) + "." + key, parameters.getString(key, null));
            }
        }
    }

    public static class OutputFormatStub
    extends AbstractFormatStub<OperatorID, OutputFormat> {
        private final OperatorID stubKey;

        public OutputFormatStub(TaskConfig config, ClassLoader classLoader, OperatorID operatorID) throws Exception {
            super(config, classLoader);
            this.stubKey = (OperatorID)((Object)Preconditions.checkNotNull((Object)((Object)operatorID)));
        }

        @Override
        public <F> Iterator<Pair<OperatorID, F>> getFormat(FormatType<F> type) {
            if (type != FormatType.OUTPUT) {
                return EmptyIterator.get();
            }
            SingleElementIterator<Pair<OperatorID, F>> iterator = new SingleElementIterator<Pair<OperatorID, F>>();
            iterator.set((Pair<OperatorID, F>)new DefaultPair((Object)this.stubKey, this.wrapper.getUserCodeObject(OutputFormat.class, this.classLoader)));
            return iterator;
        }

        @Override
        public Configuration getParameters(OperatorID key) {
            if (!this.stubKey.equals((Object)key)) {
                return new Configuration();
            }
            return this.parameters;
        }

        public static void setStubFormat(TaskConfig config, OutputFormat outputFormat) {
            config.setStubWrapper((UserCodeWrapper<?>)new UserCodeObjectWrapper((Object)outputFormat));
        }

        public static void setStubParameters(TaskConfig config, Configuration parameters) {
            config.setStubParameters(parameters);
        }
    }

    public static class InputFormatStub
    extends AbstractFormatStub<OperatorID, InputFormat> {
        private final OperatorID stubKey;

        public InputFormatStub(TaskConfig config, ClassLoader classLoader, OperatorID operatorID) throws Exception {
            super(config, classLoader);
            this.stubKey = (OperatorID)((Object)Preconditions.checkNotNull((Object)((Object)operatorID)));
        }

        @Override
        public <F> Iterator<Pair<OperatorID, F>> getFormat(FormatType<F> type) {
            if (type != FormatType.INPUT) {
                return EmptyIterator.get();
            }
            SingleElementIterator<Pair<OperatorID, F>> iterator = new SingleElementIterator<Pair<OperatorID, F>>();
            iterator.set((Pair<OperatorID, F>)new DefaultPair((Object)this.stubKey, this.wrapper.getUserCodeObject(InputFormat.class, this.classLoader)));
            return iterator;
        }

        @Override
        public Configuration getParameters(OperatorID key) {
            if (!this.stubKey.equals((Object)key)) {
                return new Configuration();
            }
            return this.parameters;
        }

        public static void setStubFormat(TaskConfig config, InputFormat inputFormat) {
            config.setStubWrapper((UserCodeWrapper<?>)new UserCodeObjectWrapper((Object)inputFormat));
        }

        public static void setStubParameters(TaskConfig config, Configuration parameters) {
            config.setStubParameters(parameters);
        }
    }

    public static class FormatType<F> {
        public static final FormatType<InputFormat> INPUT = new FormatType();
        public static final FormatType<OutputFormat> OUTPUT = new FormatType();
    }
}

