/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobType;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.ScheduleMode;
import org.apache.flink.runtime.jobgraph.tasks.JobCheckpointingSettings;
import org.apache.flink.runtime.resourcemanager.placementconstraint.PlacementConstraint;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class JobGraph
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<JobVertexID, JobVertex> taskVertices = new LinkedHashMap<JobVertexID, JobVertex>();
    private final Map<IntermediateDataSetID, IntermediateDataSet> results = new HashMap<IntermediateDataSetID, IntermediateDataSet>();
    private final Configuration jobConfiguration = new Configuration();
    private final Configuration schedulingConfiguration = new Configuration();
    private final JobID jobID;
    private final String jobName;
    private JobType jobType;
    private long sessionTimeout = 0L;
    private boolean allowQueuedScheduling;
    private boolean hasNonDeterministicShuffles = false;
    private List<PlacementConstraint> placementConstraints = new ArrayList<PlacementConstraint>();
    private long jobVersion = 0L;
    private SerializedValue<ExecutionConfig> serializedExecutionConfig;
    private JobCheckpointingSettings snapshotSettings;
    private SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.none();
    private final List<Path> userJars = new ArrayList<Path>();
    private final Map<String, DistributedCache.DistributedCacheEntry> userArtifacts = new HashMap<String, DistributedCache.DistributedCacheEntry>();
    private final List<PermanentBlobKey> userJarBlobKeys = new ArrayList<PermanentBlobKey>();
    private List<URL> classpaths = Collections.emptyList();

    public JobGraph(String jobName) {
        this(null, jobName);
    }

    public JobGraph(JobID jobId, String jobName) {
        this.jobID = jobId == null ? new JobID() : jobId;
        this.jobName = jobName == null ? "(unnamed job)" : jobName;
        try {
            this.setExecutionConfig(new ExecutionConfig());
        }
        catch (IOException e) {
            throw new RuntimeException("bug, empty execution config is not serializable");
        }
    }

    public JobGraph(JobVertex ... vertices) {
        this((String)null, vertices);
    }

    public JobGraph(String jobName, JobVertex ... vertices) {
        this(null, jobName, vertices);
    }

    public JobGraph(JobID jobId, String jobName, JobVertex ... vertices) {
        this(jobId, jobName);
        for (JobVertex vertex : vertices) {
            this.addVertex(vertex);
        }
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public String getName() {
        return this.jobName;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void addCustomConfiguration(Configuration configuration) {
        if (configuration != null) {
            this.jobConfiguration.addAll(configuration);
        }
    }

    public Configuration getSchedulingConfiguration() {
        return this.schedulingConfiguration;
    }

    public SerializedValue<ExecutionConfig> getSerializedExecutionConfig() {
        return this.serializedExecutionConfig;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setAllowQueuedScheduling(boolean allowQueuedScheduling) {
        this.allowQueuedScheduling = allowQueuedScheduling;
    }

    public boolean getAllowQueuedScheduling() {
        return this.allowQueuedScheduling;
    }

    public void setHasNonDeterministicShuffles(boolean hasNonDeterministicShuffles) {
        this.hasNonDeterministicShuffles = hasNonDeterministicShuffles;
    }

    public boolean hasNonDeterministicShuffles() {
        return this.hasNonDeterministicShuffles;
    }

    public List<PlacementConstraint> getPlacementConstraints() {
        return this.placementConstraints;
    }

    public void addPlacementConstraint(PlacementConstraint constraint) {
        this.placementConstraints.add(constraint);
    }

    public long getJobVersion() {
        return this.jobVersion;
    }

    public void setJobVersion(long newJobVersion) {
        this.jobVersion = newJobVersion;
    }

    @Deprecated
    @VisibleForTesting
    public void setScheduleMode(ScheduleMode scheduleMode) {
        this.schedulingConfiguration.setString(ScheduleMode.class.getName(), scheduleMode.toString());
        if (scheduleMode == ScheduleMode.EAGER) {
            this.setJobType(JobType.INFINITE_STREAM);
        } else {
            this.setJobType(JobType.FINITE_STREAM);
        }
    }

    public void setJobType(JobType jobType) {
        this.jobType = jobType;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public void setSavepointRestoreSettings(SavepointRestoreSettings settings) {
        this.savepointRestoreSettings = (SavepointRestoreSettings)Preconditions.checkNotNull((Object)settings, (String)"Savepoint restore settings");
    }

    public SavepointRestoreSettings getSavepointRestoreSettings() {
        return this.savepointRestoreSettings;
    }

    public void setExecutionConfig(ExecutionConfig executionConfig) throws IOException {
        Preconditions.checkNotNull((Object)executionConfig, (String)"ExecutionConfig must not be null.");
        this.serializedExecutionConfig = new SerializedValue((Object)executionConfig);
    }

    public void addVertex(JobVertex vertex) {
        JobVertexID id = vertex.getID();
        JobVertex previous = this.taskVertices.put(id, vertex);
        if (previous != null) {
            this.taskVertices.put(id, previous);
            throw new IllegalArgumentException("The JobGraph already contains a vertex with that id.");
        }
    }

    public void addVertices(Collection<JobVertex> vertices) {
        Preconditions.checkNotNull(vertices);
        for (JobVertex vertex : vertices) {
            this.addVertex(vertex);
        }
    }

    public Iterable<JobVertex> getVertices() {
        return this.taskVertices.values();
    }

    public JobVertex[] getVerticesAsArray() {
        return this.taskVertices.values().toArray(new JobVertex[this.taskVertices.size()]);
    }

    public int getNumberOfVertices() {
        return this.taskVertices.size();
    }

    public void setSnapshotSettings(JobCheckpointingSettings settings) {
        this.snapshotSettings = settings;
    }

    public JobCheckpointingSettings getCheckpointingSettings() {
        return this.snapshotSettings;
    }

    public boolean isCheckpointingEnabled() {
        if (this.snapshotSettings == null) {
            return false;
        }
        long checkpointInterval = this.snapshotSettings.getCheckpointCoordinatorConfiguration().getCheckpointInterval();
        return checkpointInterval > 0L && checkpointInterval < Long.MAX_VALUE;
    }

    public JobVertex findVertexByID(JobVertexID id) {
        return this.taskVertices.get((Object)id);
    }

    public void setClasspaths(List<URL> paths) {
        this.classpaths = paths;
    }

    public List<URL> getClasspaths() {
        return this.classpaths;
    }

    public int getMaximumParallelism() {
        int maxParallelism = -1;
        for (JobVertex vertex : this.taskVertices.values()) {
            maxParallelism = Math.max(vertex.getParallelism(), maxParallelism);
        }
        return maxParallelism;
    }

    public List<Collection<ExecutionVertexID>> getResultPartitionConsumerExecutionVertices(IntermediateDataSetID resultID, int partitionNumber) {
        IntermediateDataSet result = this.getResult(resultID);
        if (result == null) {
            throw new IllegalArgumentException("Cannot find the given result " + (Object)((Object)resultID) + " in job graph");
        }
        if (partitionNumber >= result.getProducer().getParallelism()) {
            throw new IllegalArgumentException("Result partition index out of bounds: " + partitionNumber + "/" + result.getProducer().getParallelism());
        }
        ArrayList<Collection<ExecutionVertexID>> consumerVertices = new ArrayList<Collection<ExecutionVertexID>>();
        for (JobEdge edge : this.getResult(resultID).getConsumers()) {
            consumerVertices.add(edge.getConsumerExecutionVertices(partitionNumber));
        }
        return consumerVertices;
    }

    public JobVertexID getResultProducerID(IntermediateDataSetID resultID) {
        IntermediateDataSet result = this.getResult(resultID);
        if (result == null) {
            throw new IllegalArgumentException("Cannot find the given result " + (Object)((Object)resultID) + " in job graph");
        }
        return result.getProducer().getID();
    }

    public Collection<IntermediateDataSetID> getResultIDs() {
        for (JobVertex vertex : this.getVertices()) {
            for (IntermediateDataSet result : vertex.getProducedDataSets()) {
                this.results.put(result.getId(), result);
            }
        }
        return this.results.keySet();
    }

    public IntermediateDataSet getResult(IntermediateDataSetID resultID) {
        if (!this.results.containsKey((Object)resultID)) {
            for (JobVertex vertex : this.getVertices()) {
                for (IntermediateDataSet result : vertex.getProducedDataSets()) {
                    this.results.put(result.getId(), result);
                }
            }
        }
        return this.results.get((Object)resultID);
    }

    public List<JobVertex> getVerticesSortedTopologicallyFromSources() throws InvalidProgramException {
        if (this.taskVertices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JobVertex> sorted = new ArrayList<JobVertex>(this.taskVertices.size());
        LinkedHashSet<JobVertex> remaining = new LinkedHashSet<JobVertex>(this.taskVertices.values());
        Iterator iter = remaining.iterator();
        while (iter.hasNext()) {
            JobVertex vertex = (JobVertex)iter.next();
            if (!vertex.hasNoConnectedInputs()) continue;
            sorted.add(vertex);
            iter.remove();
        }
        int startNodePos = 0;
        while (!remaining.isEmpty()) {
            if (startNodePos >= sorted.size()) {
                throw new InvalidProgramException("The job graph is cyclic.");
            }
            JobVertex current = (JobVertex)sorted.get(startNodePos++);
            this.addNodesThatHaveNoNewPredecessors(current, sorted, remaining);
        }
        return sorted;
    }

    private void addNodesThatHaveNoNewPredecessors(JobVertex start2, List<JobVertex> target, Set<JobVertex> remaining) {
        for (IntermediateDataSet dataSet : start2.getProducedDataSets()) {
            for (JobEdge edge : dataSet.getConsumers()) {
                JobVertex v = edge.getTarget();
                if (!remaining.contains(v)) continue;
                boolean hasNewPredecessors = false;
                for (JobEdge e : v.getInputs()) {
                    IntermediateDataSet source;
                    if (e == edge || !remaining.contains((source = e.getSource()).getProducer())) continue;
                    hasNewPredecessors = true;
                    break;
                }
                if (hasNewPredecessors) continue;
                target.add(v);
                remaining.remove(v);
                this.addNodesThatHaveNoNewPredecessors(v, target, remaining);
            }
        }
    }

    public void addJar(Path jar) {
        if (jar == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJars.contains(jar)) {
            this.userJars.add(jar);
        }
    }

    public List<Path> getUserJars() {
        return this.userJars;
    }

    public void addUserArtifact(String name, DistributedCache.DistributedCacheEntry file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.userArtifacts.putIfAbsent(name, file);
    }

    public Map<String, DistributedCache.DistributedCacheEntry> getUserArtifacts() {
        return this.userArtifacts;
    }

    public void addUserJarBlobKey(PermanentBlobKey key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        if (!this.userJarBlobKeys.contains(key)) {
            this.userJarBlobKeys.add(key);
        }
    }

    public boolean hasUsercodeJarFiles() {
        return this.userJars.size() > 0;
    }

    public List<PermanentBlobKey> getUserJarBlobKeys() {
        return this.userJarBlobKeys;
    }

    public String toString() {
        return "JobGraph(jobId: " + this.jobID + ")";
    }

    public void setUserArtifactBlobKey(String entryName, PermanentBlobKey blobKey) throws IOException {
        byte[] serializedBlobKey = InstantiationUtil.serializeObject((Object)blobKey);
        this.userArtifacts.computeIfPresent(entryName, (key, originalEntry) -> new DistributedCache.DistributedCacheEntry(originalEntry.filePath, originalEntry.isExecutable, serializedBlobKey, originalEntry.isZipped));
    }

    public void writeUserArtifactEntriesToConfiguration() {
        for (Map.Entry<String, DistributedCache.DistributedCacheEntry> userArtifact : this.userArtifacts.entrySet()) {
            DistributedCache.writeFileInfoToConfig((String)userArtifact.getKey(), (DistributedCache.DistributedCacheEntry)userArtifact.getValue(), (Configuration)this.jobConfiguration);
        }
    }
}

