/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.runtime.jobgraph.FormatUtil;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.util.TaskConfig;

public class MultiInputOutputFormatVertex
extends JobVertex {
    private static final long serialVersionUID = 1L;
    private Map<OperatorID, String> formatDescriptionMap = new HashMap<OperatorID, String>();

    public MultiInputOutputFormatVertex(String name) {
        super(name);
    }

    public MultiInputOutputFormatVertex(String name, JobVertexID id, List<JobVertexID> alternativeIds, List<OperatorID> operatorIds, List<OperatorID> alternativeOperatorIds) {
        super(name, id, alternativeIds, operatorIds, alternativeOperatorIds);
    }

    public void setFormatDescription(OperatorID operatorId, String formatDescription) {
        this.formatDescriptionMap.put(operatorId, formatDescription);
    }

    public String getFormatDescription(OperatorID operatorId) {
        return this.formatDescriptionMap.get((Object)operatorId);
    }

    @Override
    public void initializeOnMaster(ClassLoader loader) throws Exception {
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        FormatUtil.MultiFormatStub stub = new FormatUtil.MultiFormatStub(cfg, loader);
        FormatUtil.initializeInputFormatsOnMaster(this, stub, Collections.unmodifiableMap(this.formatDescriptionMap));
        FormatUtil.initializeOutputFormatsOnMaster(this, stub, Collections.unmodifiableMap(this.formatDescriptionMap));
    }

    @Override
    public void finalizeOnMaster(ClassLoader loader) throws Exception {
        TaskConfig cfg = new TaskConfig(this.getConfiguration());
        FormatUtil.MultiFormatStub stub = new FormatUtil.MultiFormatStub(cfg, loader);
        FormatUtil.finalizeOutputFormatsOnMaster(this, stub, Collections.unmodifiableMap(this.formatDescriptionMap));
    }
}

